package software.amazon.awscdk.services.iam;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-13T10:21:34.474Z")
public interface RoleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
     * which can assume this role.
     * 
     * You can later modify the assume role policy document by accessing it via
     * the `assumeRolePolicy` property.
     */
    software.amazon.awscdk.services.iam.PolicyPrincipal getAssumedBy();
    /**
     * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
     * which can assume this role.
     * 
     * You can later modify the assume role policy document by accessing it via
     * the `assumeRolePolicy` property.
     */
    void setAssumedBy(final software.amazon.awscdk.services.iam.PolicyPrincipal value);
    /**
     * A list of named policies to inline into this role. These policies will be
     * created with the role, whereas those added by ``addToPolicy`` are added
     * using a separate CloudFormation resource (allowing a way around circular
     * dependencies that could otherwise be introduced).
     * @default No policy is inlined in the Role resource.
     */
    java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> getInlinePolicies();
    /**
     * A list of named policies to inline into this role. These policies will be
     * created with the role, whereas those added by ``addToPolicy`` are added
     * using a separate CloudFormation resource (allowing a way around circular
     * dependencies that could otherwise be introduced).
     * @default No policy is inlined in the Role resource.
     */
    void setInlinePolicies(final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> value);
    /**
     * A list of ARNs for managed policies associated with this role.
     * You can add managed policies later using `attachManagedPolicy(arn)`.
     * @default No managed policies.
     */
    java.util.List<java.lang.String> getManagedPolicyArns();
    /**
     * A list of ARNs for managed policies associated with this role.
     * You can add managed policies later using `attachManagedPolicy(arn)`.
     * @default No managed policies.
     */
    void setManagedPolicyArns(final java.util.List<java.lang.String> value);
    /**
     * The maximum session duration (in seconds) that you want to set for the
     * specified role. If you do not specify a value for this setting, the
     * default maximum of one hour is applied. This setting can have a value
     * from 1 hour (3600sec) to 12 (43200sec) hours.
     * 
     * Anyone who assumes the role from the AWS CLI or API can use the
     * DurationSeconds API parameter or the duration-seconds CLI parameter to
     * request a longer session. The MaxSessionDuration setting determines the
     * maximum duration that can be requested using the DurationSeconds
     * parameter.
     * 
     * If users don't specify a value for the DurationSeconds parameter, their
     * security credentials are valid for one hour by default. This applies when
     * you use the AssumeRole* API operations or the assume-role* CLI operations
     * but does not apply when you use those operations to create a console URL.
     * @link https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html
     */
    java.lang.Number getMaxSessionDurationSec();
    /**
     * The maximum session duration (in seconds) that you want to set for the
     * specified role. If you do not specify a value for this setting, the
     * default maximum of one hour is applied. This setting can have a value
     * from 1 hour (3600sec) to 12 (43200sec) hours.
     * 
     * Anyone who assumes the role from the AWS CLI or API can use the
     * DurationSeconds API parameter or the duration-seconds CLI parameter to
     * request a longer session. The MaxSessionDuration setting determines the
     * maximum duration that can be requested using the DurationSeconds
     * parameter.
     * 
     * If users don't specify a value for the DurationSeconds parameter, their
     * security credentials are valid for one hour by default. This applies when
     * you use the AssumeRole* API operations or the assume-role* CLI operations
     * but does not apply when you use those operations to create a console URL.
     * @link https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html
     */
    void setMaxSessionDurationSec(final java.lang.Number value);
    /**
     * The path associated with this role. For information about IAM paths, see
     * Friendly Names and Paths in IAM User Guide.
     */
    java.lang.String getPath();
    /**
     * The path associated with this role. For information about IAM paths, see
     * Friendly Names and Paths in IAM User Guide.
     */
    void setPath(final java.lang.String value);
    /**
     * A name for the IAM role. For valid values, see the RoleName parameter for
     * the CreateRole action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the group name.
     * 
     * IMPORTANT: If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     */
    java.lang.String getRoleName();
    /**
     * A name for the IAM role. For valid values, see the RoleName parameter for
     * the CreateRole action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the group name.
     * 
     * IMPORTANT: If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     */
    void setRoleName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link RoleProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RoleProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.iam.PolicyPrincipal _assumedBy;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> _inlinePolicies;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _managedPolicyArns;
        @javax.annotation.Nullable
        private java.lang.Number _maxSessionDurationSec;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.String _roleName;

        /**
         * Sets the value of AssumedBy
         * @param value The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
which can assume this role.

You can later modify the assume role policy document by accessing it via
the `assumeRolePolicy` property.
         * @return {@code this}
         */
        public Builder withAssumedBy(final software.amazon.awscdk.services.iam.PolicyPrincipal value) {
            this._assumedBy = java.util.Objects.requireNonNull(value, "assumedBy is required");
            return this;
        }
        /**
         * Sets the value of InlinePolicies
         * @param value A list of named policies to inline into this role. These policies will be
created with the role, whereas those added by ``addToPolicy`` are added
using a separate CloudFormation resource (allowing a way around circular
dependencies that could otherwise be introduced).
         * @return {@code this}
         */
        public Builder withInlinePolicies(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> value) {
            this._inlinePolicies = value;
            return this;
        }
        /**
         * Sets the value of ManagedPolicyArns
         * @param value A list of ARNs for managed policies associated with this role.
You can add managed policies later using `attachManagedPolicy(arn)`.
         * @return {@code this}
         */
        public Builder withManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._managedPolicyArns = value;
            return this;
        }
        /**
         * Sets the value of MaxSessionDurationSec
         * @param value The maximum session duration (in seconds) that you want to set for the
specified role. If you do not specify a value for this setting, the
default maximum of one hour is applied. This setting can have a value
from 1 hour (3600sec) to 12 (43200sec) hours.

Anyone who assumes the role from the AWS CLI or API can use the
DurationSeconds API parameter or the duration-seconds CLI parameter to
request a longer session. The MaxSessionDuration setting determines the
maximum duration that can be requested using the DurationSeconds
parameter.

If users don't specify a value for the DurationSeconds parameter, their
security credentials are valid for one hour by default. This applies when
you use the AssumeRole* API operations or the assume-role* CLI operations
but does not apply when you use those operations to create a console URL.
         * @return {@code this}
         */
        public Builder withMaxSessionDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._maxSessionDurationSec = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path associated with this role. For information about IAM paths, see
Friendly Names and Paths in IAM User Guide.
         * @return {@code this}
         */
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of RoleName
         * @param value A name for the IAM role. For valid values, see the RoleName parameter for
the CreateRole action in the IAM API Reference. If you don't specify a
name, AWS CloudFormation generates a unique physical ID and uses that ID
for the group name.

IMPORTANT: If you specify a name, you cannot perform updates that require
replacement of this resource. You can perform updates that require no or
some interruption. If you must replace the resource, specify a new name.

If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
acknowledge your template's capabilities. For more information, see
Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @return {@code this}
         */
        public Builder withRoleName(@javax.annotation.Nullable final java.lang.String value) {
            this._roleName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public RoleProps build() {
            return new RoleProps() {
                private software.amazon.awscdk.services.iam.PolicyPrincipal $assumedBy = java.util.Objects.requireNonNull(_assumedBy, "assumedBy is required");
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> $inlinePolicies = _inlinePolicies;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $managedPolicyArns = _managedPolicyArns;
                @javax.annotation.Nullable
                private java.lang.Number $maxSessionDurationSec = _maxSessionDurationSec;
                @javax.annotation.Nullable
                private java.lang.String $path = _path;
                @javax.annotation.Nullable
                private java.lang.String $roleName = _roleName;

                @Override
                public software.amazon.awscdk.services.iam.PolicyPrincipal getAssumedBy() {
                    return this.$assumedBy;
                }

                @Override
                public void setAssumedBy(final software.amazon.awscdk.services.iam.PolicyPrincipal value) {
                    this.$assumedBy = java.util.Objects.requireNonNull(value, "assumedBy is required");
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> getInlinePolicies() {
                    return this.$inlinePolicies;
                }

                @Override
                public void setInlinePolicies(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> value) {
                    this.$inlinePolicies = value;
                }

                @Override
                public java.util.List<java.lang.String> getManagedPolicyArns() {
                    return this.$managedPolicyArns;
                }

                @Override
                public void setManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$managedPolicyArns = value;
                }

                @Override
                public java.lang.Number getMaxSessionDurationSec() {
                    return this.$maxSessionDurationSec;
                }

                @Override
                public void setMaxSessionDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$maxSessionDurationSec = value;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$path = value;
                }

                @Override
                public java.lang.String getRoleName() {
                    return this.$roleName;
                }

                @Override
                public void setRoleName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$roleName = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.RoleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
         * which can assume this role.
         * 
         * You can later modify the assume role policy document by accessing it via
         * the `assumeRolePolicy` property.
         */
        @Override
        public software.amazon.awscdk.services.iam.PolicyPrincipal getAssumedBy() {
            return this.jsiiGet("assumedBy", software.amazon.awscdk.services.iam.PolicyPrincipal.class);
        }

        /**
         * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
         * which can assume this role.
         * 
         * You can later modify the assume role policy document by accessing it via
         * the `assumeRolePolicy` property.
         */
        @Override
        public void setAssumedBy(final software.amazon.awscdk.services.iam.PolicyPrincipal value) {
            this.jsiiSet("assumedBy", java.util.Objects.requireNonNull(value, "assumedBy is required"));
        }

        /**
         * A list of named policies to inline into this role. These policies will be
         * created with the role, whereas those added by ``addToPolicy`` are added
         * using a separate CloudFormation resource (allowing a way around circular
         * dependencies that could otherwise be introduced).
         * @default No policy is inlined in the Role resource.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> getInlinePolicies() {
            return this.jsiiGet("inlinePolicies", java.util.Map.class);
        }

        /**
         * A list of named policies to inline into this role. These policies will be
         * created with the role, whereas those added by ``addToPolicy`` are added
         * using a separate CloudFormation resource (allowing a way around circular
         * dependencies that could otherwise be introduced).
         * @default No policy is inlined in the Role resource.
         */
        @Override
        public void setInlinePolicies(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> value) {
            this.jsiiSet("inlinePolicies", value);
        }

        /**
         * A list of ARNs for managed policies associated with this role.
         * You can add managed policies later using `attachManagedPolicy(arn)`.
         * @default No managed policies.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getManagedPolicyArns() {
            return this.jsiiGet("managedPolicyArns", java.util.List.class);
        }

        /**
         * A list of ARNs for managed policies associated with this role.
         * You can add managed policies later using `attachManagedPolicy(arn)`.
         * @default No managed policies.
         */
        @Override
        public void setManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("managedPolicyArns", value);
        }

        /**
         * The maximum session duration (in seconds) that you want to set for the
         * specified role. If you do not specify a value for this setting, the
         * default maximum of one hour is applied. This setting can have a value
         * from 1 hour (3600sec) to 12 (43200sec) hours.
         * 
         * Anyone who assumes the role from the AWS CLI or API can use the
         * DurationSeconds API parameter or the duration-seconds CLI parameter to
         * request a longer session. The MaxSessionDuration setting determines the
         * maximum duration that can be requested using the DurationSeconds
         * parameter.
         * 
         * If users don't specify a value for the DurationSeconds parameter, their
         * security credentials are valid for one hour by default. This applies when
         * you use the AssumeRole* API operations or the assume-role* CLI operations
         * but does not apply when you use those operations to create a console URL.
         * @link https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMaxSessionDurationSec() {
            return this.jsiiGet("maxSessionDurationSec", java.lang.Number.class);
        }

        /**
         * The maximum session duration (in seconds) that you want to set for the
         * specified role. If you do not specify a value for this setting, the
         * default maximum of one hour is applied. This setting can have a value
         * from 1 hour (3600sec) to 12 (43200sec) hours.
         * 
         * Anyone who assumes the role from the AWS CLI or API can use the
         * DurationSeconds API parameter or the duration-seconds CLI parameter to
         * request a longer session. The MaxSessionDuration setting determines the
         * maximum duration that can be requested using the DurationSeconds
         * parameter.
         * 
         * If users don't specify a value for the DurationSeconds parameter, their
         * security credentials are valid for one hour by default. This applies when
         * you use the AssumeRole* API operations or the assume-role* CLI operations
         * but does not apply when you use those operations to create a console URL.
         * @link https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html
         */
        @Override
        public void setMaxSessionDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("maxSessionDurationSec", value);
        }

        /**
         * The path associated with this role. For information about IAM paths, see
         * Friendly Names and Paths in IAM User Guide.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * The path associated with this role. For information about IAM paths, see
         * Friendly Names and Paths in IAM User Guide.
         */
        @Override
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }

        /**
         * A name for the IAM role. For valid values, see the RoleName parameter for
         * the CreateRole action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the group name.
         * 
         * IMPORTANT: If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRoleName() {
            return this.jsiiGet("roleName", java.lang.String.class);
        }

        /**
         * A name for the IAM role. For valid values, see the RoleName parameter for
         * the CreateRole action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the group name.
         * 
         * IMPORTANT: If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         */
        @Override
        public void setRoleName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("roleName", value);
        }
    }
}
