package software.amazon.awscdk.services.iam;

/**
 * IAM Role
 * 
 * Defines an IAM role. The role is created with an assume policy document associated with
 * the specified AWS service principal defined in `serviceAssumeRole`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:46:16.107Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Role")
public class Role extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.iam.IRole {
    protected Role(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Role(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Import a role that already exists
     */
    public static software.amazon.awscdk.services.iam.IRole import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.RoleImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "import", software.amazon.awscdk.services.iam.IRole.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Adds a permission to the role's default policy document.
     * If there is no default policy attached to this role, it will be created.
     */
    @Override
    public void addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Attaches a policy to this role.
     * @param policy The policy to attach
     */
    @Override
    public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(policy, "policy is required")).toArray());
    }

    /**
     * Attaches a managed policy to this role.
     * @param arn The ARN of the managed policy to attach.
     */
    @Override
    public void attachManagedPolicy(final java.lang.String arn) {
        this.jsiiCall("attachManagedPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(arn, "arn is required")).toArray());
    }

    /**
     * Export this role to another stack.
     */
    @Override
    public software.amazon.awscdk.services.iam.RoleImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.iam.RoleImportProps.class);
    }

    /**
     * Returns the role.
     */
    @Override
    public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
        return this.jsiiGet("dependencyElements", java.util.List.class);
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    public software.amazon.awscdk.services.iam.PolicyPrincipal getPrincipal() {
        return this.jsiiGet("principal", software.amazon.awscdk.services.iam.PolicyPrincipal.class);
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    public java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }

    /**
     * Returns the stable and unique string identifying the role. For example,
     * AIDAJQABLZS4A3QDU576Q.
     */
    @Override
    public java.lang.String getRoleId() {
        return this.jsiiGet("roleId", java.lang.String.class);
    }

    /**
     * Returns the name of the role.
     */
    public java.lang.String getRoleName() {
        return this.jsiiGet("roleName", java.lang.String.class);
    }

    /**
     * The assume role policy document associated with this role.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.PolicyDocument getAssumeRolePolicy() {
        return this.jsiiGet("assumeRolePolicy", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }
}
