package software.amazon.awscdk.services.iam;

/**
 * A construct that represents an IAM principal, such as a user, group or role.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T11:10:54.840Z")
public interface IPrincipal extends software.amazon.jsii.JsiiSerializable {
    /**
     * The IAM principal of this identity (i.e. AWS principal, service principal, etc).
     */
    software.amazon.awscdk.services.iam.PolicyPrincipal getPrincipal();
    /**
     * Adds an IAM statement to the default inline policy associated with this
     * principal. If a policy doesn't exist, it is created.
     */
    void addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement);
    /**
     * Attaches an inline policy to this principal.
     * This is the same as calling `policy.addToXxx(principal)`.
     * @param policy The policy resource to attach to this principal.
     */
    void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy);
    /**
     * Attaches a managed policy to this principal.
     * @param arn The ARN of the managed policy
     */
    void attachManagedPolicy(final java.lang.String arn);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IPrincipal {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The IAM principal of this identity (i.e. AWS principal, service principal, etc).
         */
        @Override
        public software.amazon.awscdk.services.iam.PolicyPrincipal getPrincipal() {
            return this.jsiiGet("principal", software.amazon.awscdk.services.iam.PolicyPrincipal.class);
        }

        /**
         * Adds an IAM statement to the default inline policy associated with this
         * principal. If a policy doesn't exist, it is created.
         */
        @Override
        public void addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
            this.jsiiCall("addToPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
        }

        /**
         * Attaches an inline policy to this principal.
         * This is the same as calling `policy.addToXxx(principal)`.
         * @param policy The policy resource to attach to this principal.
         */
        @Override
        public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
            this.jsiiCall("attachInlinePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(policy, "policy is required")).toArray());
        }

        /**
         * Attaches a managed policy to this principal.
         * @param arn The ARN of the managed policy
         */
        @Override
        public void attachManagedPolicy(final java.lang.String arn) {
            this.jsiiCall("attachManagedPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(arn, "arn is required")).toArray());
        }
    }
}
