package software.amazon.awscdk.services.iam;

/**
 * The AWS::IAM::Policy resource associates an IAM policy with IAM users, roles,
 * or groups. For more information about IAM policies, see [Overview of IAM
 * Policies](http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
 * in the IAM User Guide guide.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:07:04.877Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Policy")
public class Policy extends software.amazon.awscdk.Construct {
    protected Policy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Policy(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.iam.PolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    public Policy(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    /**
     * Adds a statement to the policy document.
     */
    public void addStatement(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addStatement", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Attaches this policy to a group.
     */
    public void attachToGroup(final software.amazon.awscdk.services.iam.Group group) {
        this.jsiiCall("attachToGroup", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(group, "group is required")).toArray());
    }

    /**
     * Attaches this policy to a role.
     */
    public void attachToRole(final software.amazon.awscdk.services.iam.IRole role) {
        this.jsiiCall("attachToRole", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(role, "role is required")).toArray());
    }

    /**
     * Attaches this policy to a user.
     */
    public void attachToUser(final software.amazon.awscdk.services.iam.User user) {
        this.jsiiCall("attachToUser", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(user, "user is required")).toArray());
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @Override
    protected java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * The policy document.
     */
    public software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return this.jsiiGet("document", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }

    /**
     * The name of this policy.
     */
    public java.lang.String getPolicyName() {
        return this.jsiiGet("policyName", java.lang.String.class);
    }
}
