package software.amazon.awscdk.services.iam;

/**
 * A policy prinicipal for canonicalUserIds - useful for S3 bucket policies that use
 * Origin Access identities.
 * 
 * See https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html
 * 
 * and
 * 
 * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
 * 
 * for more details.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-07T22:12:27.269Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CanonicalUserPrincipal")
public class CanonicalUserPrincipal extends software.amazon.awscdk.services.iam.PolicyPrincipal {
    protected CanonicalUserPrincipal(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public CanonicalUserPrincipal(final java.lang.String canonicalUserId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.of(java.util.Objects.requireNonNull(canonicalUserId, "canonicalUserId is required")).toArray());
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    public software.amazon.awscdk.services.iam.PrincipalPolicyFragment policyFragment() {
        return this.jsiiCall("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }

    public java.lang.String getCanonicalUserId() {
        return this.jsiiGet("canonicalUserId", java.lang.String.class);
    }
}
