package software.amazon.awscdk.services.iam;

/**
 * Result of a grant() operation
 * 
 * This class is not instantiable by consumers on purpose, so that they will be
 * required to call the Grant factory functions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:02:55.393Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Grant")
public class Grant extends software.amazon.jsii.JsiiObject {
    protected Grant(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Try to grant the given permissions to the given principal
     * 
     * Absence of a principal leads to a warning, but failing to add
     * the permissions to a present principal is not an error.
     */
    public static software.amazon.awscdk.services.iam.Grant addToPrincipal(final software.amazon.awscdk.services.iam.GrantOnPrincipalOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Grant.class, "addToPrincipal", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(options, "options is required")).toArray());
    }

    /**
     * Add a grant both on the principal and on the resource
     * 
     * As long as any principal is given, granting on the pricipal may fail (in
     * case of a non-identity principal), but granting on the resource will
     * never fail.
     * 
     * Statement will be the resource statement.
     */
    public static software.amazon.awscdk.services.iam.Grant addToPrincipalAndResource(final software.amazon.awscdk.services.iam.GrantOnPrincipalAndResourceOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Grant.class, "addToPrincipalAndResource", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(options, "options is required")).toArray());
    }

    /**
     * Grant the given permissions to the principal
     * 
     * The permissions will be added to the principal policy primarily, falling
     * back to the resource policy if necessary. The permissions must be granted
     * somewhere.
     * 
     * - Trying to grant permissions to a principal that does not admit adding to
     *    the principal policy while not providing a resource with a resource policy
     *    is an error.
     * - Trying to grant permissions to an absent principal (possible in the
     *    case of imported resources) leads to a warning being added to the
     *    resource construct.
     */
    public static software.amazon.awscdk.services.iam.Grant addToPrincipalOrResource(final software.amazon.awscdk.services.iam.GrantWithResourceOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Grant.class, "addToPrincipalOrResource", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(options, "options is required")).toArray());
    }

    /**
     * Throw an error if this grant wasn't successful
     */
    public void assertSuccess() {
        this.jsiiCall("assertSuccess", Void.class);
    }

    /**
     * Whether the grant operation was successful
     */
    public java.lang.Boolean getSuccess() {
        return this.jsiiGet("success", java.lang.Boolean.class);
    }

    /**
     * The statement that was added to the principal's policy
     * 
     * Can be accessed to (e.g.) add additional conditions to the statement.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.PolicyStatement getPrincipalStatement() {
        return this.jsiiGet("principalStatement", software.amazon.awscdk.services.iam.PolicyStatement.class);
    }

    /**
     * The statement that was added to the resource policy
     * 
     * Can be accessed to (e.g.) add additional conditions to the statement.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.PolicyStatement getResourceStatement() {
        return this.jsiiGet("resourceStatement", software.amazon.awscdk.services.iam.PolicyStatement.class);
    }
}
