package software.amazon.awscdk.services.iam;

/**
 * A construct that represents an IAM principal, such as a user, group or role.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:02:55.411Z")
public interface IIdentity extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IPrincipal, software.amazon.awscdk.IConstruct {
    /**
     * Attaches an inline policy to this principal.
     * This is the same as calling `policy.addToXxx(principal)`.
     * @param policy The policy resource to attach to this principal.
     */
    void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy);
    /**
     * Attaches a managed policy to this principal.
     * @param arn The ARN of the managed policy
     */
    void attachManagedPolicy(final java.lang.String arn);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IIdentity {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        public java.lang.String getAssumeRoleAction() {
            return this.jsiiGet("assumeRoleAction", java.lang.String.class);
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
        }

        /**
         * The principal to grant permissions to
         */
        @Override
        public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Attaches an inline policy to this principal.
         * This is the same as calling `policy.addToXxx(principal)`.
         * @param policy The policy resource to attach to this principal.
         */
        @Override
        public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
            this.jsiiCall("attachInlinePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(policy, "policy is required")).toArray());
        }

        /**
         * Attaches a managed policy to this principal.
         * @param arn The ARN of the managed policy
         */
        @Override
        public void attachManagedPolicy(final java.lang.String arn) {
            this.jsiiCall("attachManagedPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(arn, "arn is required")).toArray());
        }

        /**
         * Add to the policy of this principal.
         * @return true if the statement was added, false if the principal in question does not have a policy document to add the statement to.
         */
        @Override
        public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPolicy", java.lang.Boolean.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
        }
    }
}
