package software.amazon.awscdk.services.iam;

/**
 * A principal associated with an imported resource
 * 
 * Some resources have roles associated with them which they assume, such as
 * Lambda Functions, CodeBuild projects, StepFunctions machines, etc.
 * 
 * When those resources are imported, their actual roles are not always
 * imported with them. When that happens, we use an instance of this class
 * instead, which will add user warnings when statements are attempted to be
 * added to it.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:02:55.415Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.ImportedResourcePrincipal")
public class ImportedResourcePrincipal extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IPrincipal {
    protected ImportedResourcePrincipal(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public ImportedResourcePrincipal(final software.amazon.awscdk.services.iam.ImportedResourcePrincipalProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Add to the policy of this principal.
     */
    @Override
    public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPolicy", java.lang.Boolean.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    public java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * The principal to grant permissions to
     */
    @Override
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }
}
