package software.amazon.awscdk.services.iam;

@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:02:55.418Z")
public interface PolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Groups to attach this policy to.
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     */
    java.util.List<software.amazon.awscdk.services.iam.Group> getGroups();
    /**
     * The name of the policy. If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
     */
    java.lang.String getPolicyName();
    /**
     * Roles to attach this policy to.
     * You can also use `attachToRole(role)` to attach this policy to a role.
     */
    java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles();
    /**
     * Initial set of permissions to add to this policy document.
     * You can also use `addPermission(statement)` to add permissions later.
     */
    java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements();
    /**
     * Users to attach this policy to.
     * You can also use `attachToUser(user)` to attach this policy to a user.
     */
    java.util.List<software.amazon.awscdk.services.iam.User> getUsers();

    /**
     * @return a {@link Builder} of {@link PolicyProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PolicyProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.Group> _groups;
        @javax.annotation.Nullable
        private java.lang.String _policyName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IRole> _roles;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> _statements;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.User> _users;

        /**
         * Sets the value of Groups
         * @param value Groups to attach this policy to.
You can also use `attachToGroup(group)` to attach this policy to a group.
         * @return {@code this}
         */
        public Builder withGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this._groups = value;
            return this;
        }
        /**
         * Sets the value of PolicyName
         * @param value The name of the policy. If you specify multiple policies for an entity,
specify unique names. For example, if you specify a list of policies for
an IAM role, each policy must have a unique name.
         * @return {@code this}
         */
        public Builder withPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this._policyName = value;
            return this;
        }
        /**
         * Sets the value of Roles
         * @param value Roles to attach this policy to.
You can also use `attachToRole(role)` to attach this policy to a role.
         * @return {@code this}
         */
        public Builder withRoles(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IRole> value) {
            this._roles = value;
            return this;
        }
        /**
         * Sets the value of Statements
         * @param value Initial set of permissions to add to this policy document.
You can also use `addPermission(statement)` to add permissions later.
         * @return {@code this}
         */
        public Builder withStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this._statements = value;
            return this;
        }
        /**
         * Sets the value of Users
         * @param value Users to attach this policy to.
You can also use `attachToUser(user)` to attach this policy to a user.
         * @return {@code this}
         */
        public Builder withUsers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.User> value) {
            this._users = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PolicyProps build() {
            return new PolicyProps() {
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.Group> $groups = _groups;
                @javax.annotation.Nullable
                private final java.lang.String $policyName = _policyName;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IRole> $roles = _roles;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> $statements = _statements;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.User> $users = _users;

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
                    return this.$groups;
                }

                @Override
                public java.lang.String getPolicyName() {
                    return this.$policyName;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
                    return this.$roles;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
                    return this.$statements;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.User> getUsers() {
                    return this.$users;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("groups", om.valueToTree(this.getGroups()));
                    obj.set("policyName", om.valueToTree(this.getPolicyName()));
                    obj.set("roles", om.valueToTree(this.getRoles()));
                    obj.set("statements", om.valueToTree(this.getStatements()));
                    obj.set("users", om.valueToTree(this.getUsers()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.PolicyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Groups to attach this policy to.
         * You can also use `attachToGroup(group)` to attach this policy to a group.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
            return this.jsiiGet("groups", java.util.List.class);
        }

        /**
         * The name of the policy. If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPolicyName() {
            return this.jsiiGet("policyName", java.lang.String.class);
        }

        /**
         * Roles to attach this policy to.
         * You can also use `attachToRole(role)` to attach this policy to a role.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.jsiiGet("roles", java.util.List.class);
        }

        /**
         * Initial set of permissions to add to this policy document.
         * You can also use `addPermission(statement)` to add permissions later.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.jsiiGet("statements", java.util.List.class);
        }

        /**
         * Users to attach this policy to.
         * You can also use `attachToUser(user)` to attach this policy to a user.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.User> getUsers() {
            return this.jsiiGet("users", java.util.List.class);
        }
    }
}
