package software.amazon.awscdk.services.iam;

/**
 * IAM Role
 * 
 * Defines an IAM role. The role is created with an assume policy document associated with
 * the specified AWS service principal defined in `serviceAssumeRole`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:02:55.422Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Role")
public class Role extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.iam.IRole {
    protected Role(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Role(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Import a role that already exists
     */
    public static software.amazon.awscdk.services.iam.IRole import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.RoleImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "import", software.amazon.awscdk.services.iam.IRole.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Adds a permission to the role's default policy document.
     * If there is no default policy attached to this role, it will be created.
     */
    @Override
    public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPolicy", java.lang.Boolean.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Attaches a policy to this role.
     * @param policy The policy to attach
     */
    @Override
    public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(policy, "policy is required")).toArray());
    }

    /**
     * Attaches a managed policy to this role.
     * @param arn The ARN of the managed policy to attach.
     */
    @Override
    public void attachManagedPolicy(final java.lang.String arn) {
        this.jsiiCall("attachManagedPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(arn, "arn is required")).toArray());
    }

    /**
     * Export this role to another stack.
     */
    @Override
    public software.amazon.awscdk.services.iam.RoleImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.iam.RoleImportProps.class);
    }

    /**
     * Grant the actions defined in actions to the identity Principal on this resource.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grant(final software.amazon.awscdk.services.iam.IPrincipal grantee, final java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required")), java.util.Arrays.stream(java.util.Objects.requireNonNull(actions, "actions is required"))).toArray());
    }

    /**
     * Grant permissions to the given principal to pass this role.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPassRole(final software.amazon.awscdk.services.iam.IPrincipal identity) {
        return this.jsiiCall("grantPassRole", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(identity, "identity is required")).toArray());
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    public java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * The principal to grant permissions to
     */
    @Override
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * Returns the role.
     */
    @Override
    public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    public java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }

    /**
     * Returns the stable and unique string identifying the role. For example,
     * AIDAJQABLZS4A3QDU576Q.
     */
    @Override
    public java.lang.String getRoleId() {
        return this.jsiiGet("roleId", java.lang.String.class);
    }

    /**
     * Returns the name of the role.
     */
    @Override
    public java.lang.String getRoleName() {
        return this.jsiiGet("roleName", java.lang.String.class);
    }

    /**
     * The assume role policy document associated with this role.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.PolicyDocument getAssumeRolePolicy() {
        return this.jsiiGet("assumeRolePolicy", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }
}
