package software.amazon.awscdk.services.iam;

/**
 * A CloudFormation `AWS::IAM::User`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:02:15.674Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CfnUser")
public class CfnUser extends software.amazon.awscdk.CfnResource {
    protected CfnUser(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.CfnUser.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::IAM::User`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnUser(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.iam.CfnUserProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::IAM::User`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    public CfnUser(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.iam.CfnUserProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.iam.CfnUserProps.class);
    }

    /**
     */
    public java.lang.String getUserArn() {
        return this.jsiiGet("userArn", java.lang.String.class);
    }

    public java.lang.String getUserName() {
        return this.jsiiGet("userName", java.lang.String.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html
     */
    public static interface LoginProfileProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnUser.LoginProfileProperty.Password`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
         */
        java.lang.String getPassword();
        /**
         * `CfnUser.LoginProfileProperty.PasswordResetRequired`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
         */
        java.lang.Object getPasswordResetRequired();

        /**
         * @return a {@link Builder} of {@link LoginProfileProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoginProfileProperty}
         */
        final class Builder {
            private java.lang.String _password;
            @javax.annotation.Nullable
            private java.lang.Object _passwordResetRequired;

            /**
             * Sets the value of Password
             * @param value `CfnUser.LoginProfileProperty.Password`.
             * @return {@code this}
             */
            public Builder withPassword(final java.lang.String value) {
                this._password = java.util.Objects.requireNonNull(value, "password is required");
                return this;
            }
            /**
             * Sets the value of PasswordResetRequired
             * @param value `CfnUser.LoginProfileProperty.PasswordResetRequired`.
             * @return {@code this}
             */
            public Builder withPasswordResetRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._passwordResetRequired = value;
                return this;
            }
            /**
             * Sets the value of PasswordResetRequired
             * @param value `CfnUser.LoginProfileProperty.PasswordResetRequired`.
             * @return {@code this}
             */
            public Builder withPasswordResetRequired(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._passwordResetRequired = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoginProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoginProfileProperty build() {
                return new LoginProfileProperty() {
                    private final java.lang.String $password = java.util.Objects.requireNonNull(_password, "password is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $passwordResetRequired = _passwordResetRequired;

                    @Override
                    public java.lang.String getPassword() {
                        return this.$password;
                    }

                    @Override
                    public java.lang.Object getPasswordResetRequired() {
                        return this.$passwordResetRequired;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("password", om.valueToTree(this.getPassword()));
                        obj.set("passwordResetRequired", om.valueToTree(this.getPasswordResetRequired()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.CfnUser.LoginProfileProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnUser.LoginProfileProperty.Password`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
             */
            @Override
            public java.lang.String getPassword() {
                return this.jsiiGet("password", java.lang.String.class);
            }

            /**
             * `CfnUser.LoginProfileProperty.PasswordResetRequired`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPasswordResetRequired() {
                return this.jsiiGet("passwordResetRequired", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    public static interface PolicyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnUser.PolicyProperty.PolicyDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        java.lang.Object getPolicyDocument();
        /**
         * `CfnUser.PolicyProperty.PolicyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        java.lang.String getPolicyName();

        /**
         * @return a {@link Builder} of {@link PolicyProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PolicyProperty}
         */
        final class Builder {
            private java.lang.Object _policyDocument;
            private java.lang.String _policyName;

            /**
             * Sets the value of PolicyDocument
             * @param value `CfnUser.PolicyProperty.PolicyDocument`.
             * @return {@code this}
             */
            public Builder withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._policyDocument = java.util.Objects.requireNonNull(value, "policyDocument is required");
                return this;
            }
            /**
             * Sets the value of PolicyDocument
             * @param value `CfnUser.PolicyProperty.PolicyDocument`.
             * @return {@code this}
             */
            public Builder withPolicyDocument(final software.amazon.awscdk.Token value) {
                this._policyDocument = java.util.Objects.requireNonNull(value, "policyDocument is required");
                return this;
            }
            /**
             * Sets the value of PolicyName
             * @param value `CfnUser.PolicyProperty.PolicyName`.
             * @return {@code this}
             */
            public Builder withPolicyName(final java.lang.String value) {
                this._policyName = java.util.Objects.requireNonNull(value, "policyName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PolicyProperty build() {
                return new PolicyProperty() {
                    private final java.lang.Object $policyDocument = java.util.Objects.requireNonNull(_policyDocument, "policyDocument is required");
                    private final java.lang.String $policyName = java.util.Objects.requireNonNull(_policyName, "policyName is required");

                    @Override
                    public java.lang.Object getPolicyDocument() {
                        return this.$policyDocument;
                    }

                    @Override
                    public java.lang.String getPolicyName() {
                        return this.$policyName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
                        obj.set("policyName", om.valueToTree(this.getPolicyName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.CfnUser.PolicyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnUser.PolicyProperty.PolicyDocument`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            @Override
            public java.lang.Object getPolicyDocument() {
                return this.jsiiGet("policyDocument", java.lang.Object.class);
            }

            /**
             * `CfnUser.PolicyProperty.PolicyName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            @Override
            public java.lang.String getPolicyName() {
                return this.jsiiGet("policyName", java.lang.String.class);
            }
        }
    }
}
