/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.iam.Group;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.User;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface PolicyProps
extends JsiiSerializable {
    public List<Group> getGroups();

    public String getPolicyName();

    public List<IRole> getRoles();

    public List<PolicyStatement> getStatements();

    public List<User> getUsers();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<Group> _groups;
        @Nullable
        private String _policyName;
        @Nullable
        private List<IRole> _roles;
        @Nullable
        private List<PolicyStatement> _statements;
        @Nullable
        private List<User> _users;

        public Builder withGroups(@Nullable List<Group> value) {
            this._groups = value;
            return this;
        }

        public Builder withPolicyName(@Nullable String value) {
            this._policyName = value;
            return this;
        }

        public Builder withRoles(@Nullable List<IRole> value) {
            this._roles = value;
            return this;
        }

        public Builder withStatements(@Nullable List<PolicyStatement> value) {
            this._statements = value;
            return this;
        }

        public Builder withUsers(@Nullable List<User> value) {
            this._users = value;
            return this;
        }

        public PolicyProps build() {
            return new PolicyProps(){
                @Nullable
                private final List<Group> $groups;
                @Nullable
                private final String $policyName;
                @Nullable
                private final List<IRole> $roles;
                @Nullable
                private final List<PolicyStatement> $statements;
                @Nullable
                private final List<User> $users;
                {
                    this.$groups = _groups;
                    this.$policyName = _policyName;
                    this.$roles = _roles;
                    this.$statements = _statements;
                    this.$users = _users;
                }

                @Override
                public List<Group> getGroups() {
                    return this.$groups;
                }

                @Override
                public String getPolicyName() {
                    return this.$policyName;
                }

                @Override
                public List<IRole> getRoles() {
                    return this.$roles;
                }

                @Override
                public List<PolicyStatement> getStatements() {
                    return this.$statements;
                }

                @Override
                public List<User> getUsers() {
                    return this.$users;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("groups", om.valueToTree(this.getGroups()));
                    obj.set("policyName", om.valueToTree((Object)this.getPolicyName()));
                    obj.set("roles", om.valueToTree(this.getRoles()));
                    obj.set("statements", om.valueToTree(this.getStatements()));
                    obj.set("users", om.valueToTree(this.getUsers()));
                    return obj;
                }
            };
        }
    }
}

