package software.amazon.awscdk.services.iam;

/**
 * Properties to import a Role.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:08:32.861Z")
public interface RoleImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The role's ARN.
     */
    java.lang.String getRoleArn();
    /**
     * The stable and unique string identifying the role.
     * 
     * For example,
     * AIDAJQABLZS4A3QDU576Q.
     * 
     * Default: If "roleId" is not specified for an imported role, then
     * `role.roleId` will throw an exception. In most cases, role ID is not really needed.
     */
    java.lang.String getRoleId();

    /**
     * @return a {@link Builder} of {@link RoleImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RoleImportProps}
     */
    final class Builder {
        private java.lang.String _roleArn;
        @javax.annotation.Nullable
        private java.lang.String _roleId;

        /**
         * Sets the value of RoleArn
         * @param value The role's ARN.
         * @return {@code this}
         */
        public Builder withRoleArn(final java.lang.String value) {
            this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
            return this;
        }
        /**
         * Sets the value of RoleId
         * @param value The stable and unique string identifying the role.
         * @return {@code this}
         */
        public Builder withRoleId(@javax.annotation.Nullable final java.lang.String value) {
            this._roleId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoleImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public RoleImportProps build() {
            return new RoleImportProps() {
                private final java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");
                @javax.annotation.Nullable
                private final java.lang.String $roleId = _roleId;

                @Override
                public java.lang.String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public java.lang.String getRoleId() {
                    return this.$roleId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("roleArn", om.valueToTree(this.getRoleArn()));
                    obj.set("roleId", om.valueToTree(this.getRoleId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.RoleImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The role's ARN.
         */
        @Override
        public java.lang.String getRoleArn() {
            return this.jsiiGet("roleArn", java.lang.String.class);
        }

        /**
         * The stable and unique string identifying the role.
         * 
         * For example,
         * AIDAJQABLZS4A3QDU576Q.
         * 
         * Default: If "roleId" is not specified for an imported role, then
         * `role.roleId` will throw an exception. In most cases, role ID is not really needed.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRoleId() {
            return this.jsiiGet("roleId", java.lang.String.class);
        }
    }
}
