package software.amazon.awscdk.services.iam;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:08:32.864Z")
public interface UserProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Groups to add this user to.
     * 
     * You can also use `addToGroup` to add this
     * user to a group.
     */
    java.util.List<software.amazon.awscdk.services.iam.Group> getGroups();
    /**
     * A list of ARNs for managed policies attacherd to this user. You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
     * 
     * Default: No managed policies.
     */
    java.util.List<java.lang.Object> getManagedPolicyArns();
    /**
     * The password for the user. This is required so the user can access the AWS Management Console.
     * 
     * You can use `SecretValue.plainText` to specify a password in plain text or
     * use `secretsmanager.Secret.import` to reference a secret in Secrets Manager.
     * 
     * Default: User won't be able to access the management console without a password.
     */
    software.amazon.awscdk.SecretValue getPassword();
    /**
     * Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
     * 
     * If this is set to 'true', you must also specify "initialPassword".
     * 
     * Default: false
     */
    java.lang.Boolean getPasswordResetRequired();
    /**
     * The path for the user name.
     * 
     * For more information about paths, see IAM
     * Identifiers in the IAM User Guide.
     */
    java.lang.String getPath();
    /**
     * A name for the IAM user.
     * 
     * For valid values, see the UserName parameter for
     * the CreateUser action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the user name.
     * 
     * If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * 
     * Default: Generated by CloudFormation (recommended)
     */
    java.lang.String getUserName();

    /**
     * @return a {@link Builder} of {@link UserProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link UserProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.Group> _groups;
        @javax.annotation.Nullable
        private java.util.List<java.lang.Object> _managedPolicyArns;
        @javax.annotation.Nullable
        private software.amazon.awscdk.SecretValue _password;
        @javax.annotation.Nullable
        private java.lang.Boolean _passwordResetRequired;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.String _userName;

        /**
         * Sets the value of Groups
         * @param value Groups to add this user to.
         * @return {@code this}
         */
        public Builder withGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this._groups = value;
            return this;
        }
        /**
         * Sets the value of ManagedPolicyArns
         * @param value A list of ARNs for managed policies attacherd to this user. You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
         * @return {@code this}
         */
        public Builder withManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this._managedPolicyArns = value;
            return this;
        }
        /**
         * Sets the value of Password
         * @param value The password for the user. This is required so the user can access the AWS Management Console.
         * @return {@code this}
         */
        public Builder withPassword(@javax.annotation.Nullable final software.amazon.awscdk.SecretValue value) {
            this._password = value;
            return this;
        }
        /**
         * Sets the value of PasswordResetRequired
         * @param value Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
         * @return {@code this}
         */
        public Builder withPasswordResetRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._passwordResetRequired = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path for the user name.
         * @return {@code this}
         */
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of UserName
         * @param value A name for the IAM user.
         * @return {@code this}
         */
        public Builder withUserName(@javax.annotation.Nullable final java.lang.String value) {
            this._userName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public UserProps build() {
            return new UserProps() {
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.Group> $groups = _groups;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.Object> $managedPolicyArns = _managedPolicyArns;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.SecretValue $password = _password;
                @javax.annotation.Nullable
                private final java.lang.Boolean $passwordResetRequired = _passwordResetRequired;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;
                @javax.annotation.Nullable
                private final java.lang.String $userName = _userName;

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
                    return this.$groups;
                }

                @Override
                public java.util.List<java.lang.Object> getManagedPolicyArns() {
                    return this.$managedPolicyArns;
                }

                @Override
                public software.amazon.awscdk.SecretValue getPassword() {
                    return this.$password;
                }

                @Override
                public java.lang.Boolean getPasswordResetRequired() {
                    return this.$passwordResetRequired;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.lang.String getUserName() {
                    return this.$userName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("groups", om.valueToTree(this.getGroups()));
                    obj.set("managedPolicyArns", om.valueToTree(this.getManagedPolicyArns()));
                    obj.set("password", om.valueToTree(this.getPassword()));
                    obj.set("passwordResetRequired", om.valueToTree(this.getPasswordResetRequired()));
                    obj.set("path", om.valueToTree(this.getPath()));
                    obj.set("userName", om.valueToTree(this.getUserName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.UserProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Groups to add this user to.
         * 
         * You can also use `addToGroup` to add this
         * user to a group.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
            return this.jsiiGet("groups", java.util.List.class);
        }

        /**
         * A list of ARNs for managed policies attacherd to this user. You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
         * 
         * Default: No managed policies.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this.jsiiGet("managedPolicyArns", java.util.List.class);
        }

        /**
         * The password for the user. This is required so the user can access the AWS Management Console.
         * 
         * You can use `SecretValue.plainText` to specify a password in plain text or
         * use `secretsmanager.Secret.import` to reference a secret in Secrets Manager.
         * 
         * Default: User won't be able to access the management console without a password.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.SecretValue getPassword() {
            return this.jsiiGet("password", software.amazon.awscdk.SecretValue.class);
        }

        /**
         * Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
         * 
         * If this is set to 'true', you must also specify "initialPassword".
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPasswordResetRequired() {
            return this.jsiiGet("passwordResetRequired", java.lang.Boolean.class);
        }

        /**
         * The path for the user name.
         * 
         * For more information about paths, see IAM
         * Identifiers in the IAM User Guide.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * A name for the IAM user.
         * 
         * For valid values, see the UserName parameter for
         * the CreateUser action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the user name.
         * 
         * If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * 
         * Default: Generated by CloudFormation (recommended)
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getUserName() {
            return this.jsiiGet("userName", java.lang.String.class);
        }
    }
}
