package software.amazon.awscdk.services.iam;

/**
 * A CloudFormation `AWS::IAM::Role`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:13:32.282Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CfnRole")
public class CfnRole extends software.amazon.awscdk.CfnResource {
    protected CfnRole(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.CfnRole.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::IAM::Role`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnRole(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.CfnRoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.iam.CfnRoleProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.iam.CfnRoleProps.class);
    }

    /**
     */
    public java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getRoleId() {
        return this.jsiiGet("roleId", java.lang.String.class);
    }

    public java.lang.String getRoleName() {
        return this.jsiiGet("roleName", java.lang.String.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    public static interface PolicyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnRole.PolicyProperty.PolicyDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        java.lang.Object getPolicyDocument();
        /**
         * `CfnRole.PolicyProperty.PolicyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        java.lang.String getPolicyName();

        /**
         * @return a {@link Builder} of {@link PolicyProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PolicyProperty}
         */
        final class Builder {
            private java.lang.Object _policyDocument;
            private java.lang.String _policyName;

            /**
             * Sets the value of PolicyDocument
             * @param value `CfnRole.PolicyProperty.PolicyDocument`.
             * @return {@code this}
             */
            public Builder withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._policyDocument = java.util.Objects.requireNonNull(value, "policyDocument is required");
                return this;
            }
            /**
             * Sets the value of PolicyDocument
             * @param value `CfnRole.PolicyProperty.PolicyDocument`.
             * @return {@code this}
             */
            public Builder withPolicyDocument(final software.amazon.awscdk.Token value) {
                this._policyDocument = java.util.Objects.requireNonNull(value, "policyDocument is required");
                return this;
            }
            /**
             * Sets the value of PolicyName
             * @param value `CfnRole.PolicyProperty.PolicyName`.
             * @return {@code this}
             */
            public Builder withPolicyName(final java.lang.String value) {
                this._policyName = java.util.Objects.requireNonNull(value, "policyName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PolicyProperty build() {
                return new PolicyProperty() {
                    private final java.lang.Object $policyDocument = java.util.Objects.requireNonNull(_policyDocument, "policyDocument is required");
                    private final java.lang.String $policyName = java.util.Objects.requireNonNull(_policyName, "policyName is required");

                    @Override
                    public java.lang.Object getPolicyDocument() {
                        return this.$policyDocument;
                    }

                    @Override
                    public java.lang.String getPolicyName() {
                        return this.$policyName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
                        obj.set("policyName", om.valueToTree(this.getPolicyName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.CfnRole.PolicyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnRole.PolicyProperty.PolicyDocument`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            @Override
            public java.lang.Object getPolicyDocument() {
                return this.jsiiGet("policyDocument", java.lang.Object.class);
            }

            /**
             * `CfnRole.PolicyProperty.PolicyName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            @Override
            public java.lang.String getPolicyName() {
                return this.jsiiGet("policyName", java.lang.String.class);
            }
        }
    }
}
