package software.amazon.awscdk.services.iam;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:13:32.302Z")
public interface GroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A name for the IAM group.
     * 
     * For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * 
     * Default: Generated by CloudFormation (recommended)
     */
    java.lang.String getGroupName();
    /**
     * A list of ARNs for managed policies associated with group.
     * 
     * Default: - No managed policies.
     */
    java.util.List<java.lang.Object> getManagedPolicyArns();
    /**
     * The path to the group.
     * 
     * For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     * 
     * Default: /
     */
    java.lang.String getPath();

    /**
     * @return a {@link Builder} of {@link GroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GroupProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _groupName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.Object> _managedPolicyArns;
        @javax.annotation.Nullable
        private java.lang.String _path;

        /**
         * Sets the value of GroupName
         * @param value A name for the IAM group.
         * @return {@code this}
         */
        public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._groupName = value;
            return this;
        }
        /**
         * Sets the value of ManagedPolicyArns
         * @param value A list of ARNs for managed policies associated with group.
         * @return {@code this}
         */
        public Builder withManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this._managedPolicyArns = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path to the group.
         * @return {@code this}
         */
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public GroupProps build() {
            return new GroupProps() {
                @javax.annotation.Nullable
                private final java.lang.String $groupName = _groupName;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.Object> $managedPolicyArns = _managedPolicyArns;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;

                @Override
                public java.lang.String getGroupName() {
                    return this.$groupName;
                }

                @Override
                public java.util.List<java.lang.Object> getManagedPolicyArns() {
                    return this.$managedPolicyArns;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("groupName", om.valueToTree(this.getGroupName()));
                    obj.set("managedPolicyArns", om.valueToTree(this.getManagedPolicyArns()));
                    obj.set("path", om.valueToTree(this.getPath()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.GroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A name for the IAM group.
         * 
         * For valid values, see the GroupName parameter
         * for the CreateGroup action in the IAM API Reference. If you don't specify
         * a name, AWS CloudFormation generates a unique physical ID and uses that
         * ID for the group name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * 
         * Default: Generated by CloudFormation (recommended)
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }

        /**
         * A list of ARNs for managed policies associated with group.
         * 
         * Default: - No managed policies.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this.jsiiGet("managedPolicyArns", java.util.List.class);
        }

        /**
         * The path to the group.
         * 
         * For more information about paths, see [IAM
         * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
         * in the IAM User Guide.
         * 
         * Default: /
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }
    }
}
