package software.amazon.awscdk.services.iam;

/**
 * A construct that represents an IAM principal, such as a user, group or role.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:13:32.307Z")
public interface IIdentity extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IPrincipal, software.amazon.awscdk.IResource {
    /**
     * Attaches an inline policy to this principal. This is the same as calling `policy.addToXxx(principal)`.
     * 
     * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface].
     */
    void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy);
    /**
     * Attaches a managed policy to this principal.
     * 
     * @param arn The ARN of the managed policy.
     */
    void attachManagedPolicy(final java.lang.String arn);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IIdentity {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        public java.lang.String getAssumeRoleAction() {
            return this.jsiiGet("assumeRoleAction", java.lang.String.class);
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable.
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Attaches an inline policy to this principal. This is the same as calling `policy.addToXxx(principal)`.
         * 
         * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface].
         */
        @Override
        public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
            this.jsiiCall("attachInlinePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Attaches a managed policy to this principal.
         * 
         * @param arn The ARN of the managed policy.
         */
        @Override
        public void attachManagedPolicy(final java.lang.String arn) {
            this.jsiiCall("attachManagedPolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
        }

        /**
         * Add to the policy of this principal.
         * 
         * @return true if the statement was added, false if the principal in
         * question does not have a policy document to add the statement to.
         */
        @Override
        public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }
    }
}
