package software.amazon.awscdk.services.iam;

/**
 * Represents a logical IAM principal.
 * 
 * An IPrincipal describes a logical entity that can perform AWS API calls
 * against sets of resources, optionally under certain conditions.
 * 
 * Examples of simple principals are IAM objects that you create, such
 * as Users or Roles.
 * 
 * An example of a more complex principals is a `ServicePrincipal` (such as
 * `new ServicePrincipal("sns.amazonaws.com")`, which represents the Simple
 * Notifications Service).
 * 
 * A single logical Principal may also map to a set of physical principals.
 * For example, `new OrganizationPrincipal('o-1234')` represents all
 * identities that are part of the given AWS Organization.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:13:32.309Z")
public interface IPrincipal extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IGrantable {
    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    java.lang.String getAssumeRoleAction();
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment();
    /**
     * Add to the policy of this principal.
     * 
     * @return true if the statement was added, false if the principal in
     * question does not have a policy document to add the statement to.
     */
    java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IPrincipal {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        public java.lang.String getAssumeRoleAction() {
            return this.jsiiGet("assumeRoleAction", java.lang.String.class);
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * Add to the policy of this principal.
         * 
         * @return true if the statement was added, false if the principal in
         * question does not have a policy document to add the statement to.
         */
        @Override
        public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }
    }
}
