package software.amazon.awscdk.services.iam;

/**
 * A CloudFormation `AWS::IAM::Group`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:01:58.379Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CfnGroup")
public class CfnGroup extends software.amazon.awscdk.CfnResource {
    protected CfnGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.CfnGroup.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::IAM::Group`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.iam.CfnGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::IAM::Group`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    public CfnGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     */
    public java.lang.String getGroupArn() {
        return this.jsiiGet("groupArn", java.lang.String.class);
    }

    public java.lang.String getGroupName() {
        return this.jsiiGet("groupName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.iam.CfnGroupProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.iam.CfnGroupProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    public static interface PolicyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnGroup.PolicyProperty.PolicyDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        java.lang.Object getPolicyDocument();
        /**
         * `CfnGroup.PolicyProperty.PolicyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        java.lang.String getPolicyName();

        /**
         * @return a {@link Builder} of {@link PolicyProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PolicyProperty}
         */
        final class Builder {
            private java.lang.Object _policyDocument;
            private java.lang.String _policyName;

            /**
             * Sets the value of PolicyDocument
             * @param value `CfnGroup.PolicyProperty.PolicyDocument`.
             * @return {@code this}
             */
            public Builder withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._policyDocument = java.util.Objects.requireNonNull(value, "policyDocument is required");
                return this;
            }
            /**
             * Sets the value of PolicyDocument
             * @param value `CfnGroup.PolicyProperty.PolicyDocument`.
             * @return {@code this}
             */
            public Builder withPolicyDocument(final software.amazon.awscdk.Token value) {
                this._policyDocument = java.util.Objects.requireNonNull(value, "policyDocument is required");
                return this;
            }
            /**
             * Sets the value of PolicyName
             * @param value `CfnGroup.PolicyProperty.PolicyName`.
             * @return {@code this}
             */
            public Builder withPolicyName(final java.lang.String value) {
                this._policyName = java.util.Objects.requireNonNull(value, "policyName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PolicyProperty build() {
                return new PolicyProperty() {
                    private final java.lang.Object $policyDocument = java.util.Objects.requireNonNull(_policyDocument, "policyDocument is required");
                    private final java.lang.String $policyName = java.util.Objects.requireNonNull(_policyName, "policyName is required");

                    @Override
                    public java.lang.Object getPolicyDocument() {
                        return this.$policyDocument;
                    }

                    @Override
                    public java.lang.String getPolicyName() {
                        return this.$policyName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
                        obj.set("policyName", om.valueToTree(this.getPolicyName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.CfnGroup.PolicyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnGroup.PolicyProperty.PolicyDocument`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            @Override
            public java.lang.Object getPolicyDocument() {
                return this.jsiiGet("policyDocument", java.lang.Object.class);
            }

            /**
             * `CfnGroup.PolicyProperty.PolicyName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            @Override
            public java.lang.String getPolicyName() {
                return this.jsiiGet("policyName", java.lang.String.class);
            }
        }
    }
}
