package software.amazon.awscdk.services.iam;

/**
 * Represents a statement in an IAM policy document.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:01:58.432Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyStatement")
public class PolicyStatement extends software.amazon.awscdk.Token {
    protected PolicyStatement(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public PolicyStatement(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.PolicyStatementEffect effect) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { effect });
    }
    public PolicyStatement() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addAccountRootPrincipal() {
        return this.jsiiCall("addAccountRootPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class);
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addAction(final java.lang.String action) {
        return this.jsiiCall("addAction", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(action, "action is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addActions(final java.lang.String... actions) {
        return this.jsiiCall("addActions", software.amazon.awscdk.services.iam.PolicyStatement.class, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Adds a ``"*"`` resource to this statement.
     */
    public software.amazon.awscdk.services.iam.PolicyStatement addAllResources() {
        return this.jsiiCall("addAllResources", software.amazon.awscdk.services.iam.PolicyStatement.class);
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addAnyPrincipal() {
        return this.jsiiCall("addAnyPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class);
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addArnPrincipal(final java.lang.String arn) {
        return this.jsiiCall("addArnPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addAwsAccountPrincipal(final java.lang.String accountId) {
        return this.jsiiCall("addAwsAccountPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addAwsPrincipal(final java.lang.String arn) {
        return this.jsiiCall("addAwsPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addCanonicalUserPrincipal(final java.lang.String canonicalUserId) {
        return this.jsiiCall("addCanonicalUserPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(canonicalUserId, "canonicalUserId is required") });
    }

    /**
     * Add a condition to the Policy.
     */
    public software.amazon.awscdk.services.iam.PolicyStatement addCondition(final java.lang.String key, @javax.annotation.Nullable final java.lang.Object value) {
        return this.jsiiCall("addCondition", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Add multiple conditions to the Policy.
     */
    public software.amazon.awscdk.services.iam.PolicyStatement addConditions(final java.util.Map<java.lang.String, java.lang.Object> conditions) {
        return this.jsiiCall("addConditions", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addFederatedPrincipal(@javax.annotation.Nullable final java.lang.Object federated, final java.util.Map<java.lang.String, java.lang.Object> conditions) {
        return this.jsiiCall("addFederatedPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { federated, java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addPrincipal(final software.amazon.awscdk.services.iam.IPrincipal principal) {
        return this.jsiiCall("addPrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(principal, "principal is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addResource(final java.lang.String arn) {
        return this.jsiiCall("addResource", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement addResources(final java.lang.String... arns) {
        return this.jsiiCall("addResources", software.amazon.awscdk.services.iam.PolicyStatement.class, java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * Adds a service principal to this policy statement.
     * 
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`).
     * @param opts options for adding the service principal (such as specifying a principal in a different region).
     */
    public software.amazon.awscdk.services.iam.PolicyStatement addServicePrincipal(final java.lang.String service, @javax.annotation.Nullable final software.amazon.awscdk.services.iam.ServicePrincipalOpts opts) {
        return this.jsiiCall("addServicePrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), opts });
    }

    /**
     * Adds a service principal to this policy statement.
     * 
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`).
     */
    public software.amazon.awscdk.services.iam.PolicyStatement addServicePrincipal(final java.lang.String service) {
        return this.jsiiCall("addServicePrincipal", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Sets the permission effect to allow access to resources.
     */
    public software.amazon.awscdk.services.iam.PolicyStatement allow() {
        return this.jsiiCall("allow", software.amazon.awscdk.services.iam.PolicyStatement.class);
    }

    /**
     * Sets the permission effect to deny access to resources.
     */
    public software.amazon.awscdk.services.iam.PolicyStatement deny() {
        return this.jsiiCall("deny", software.amazon.awscdk.services.iam.PolicyStatement.class);
    }

    /**
     * @deprecated Use `statement.sid = value`
     */
    public software.amazon.awscdk.services.iam.PolicyStatement describe(final java.lang.String sid) {
        return this.jsiiCall("describe", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(sid, "sid is required") });
    }

    public software.amazon.awscdk.services.iam.PolicyStatement limitToAccount(final java.lang.String accountId) {
        return this.jsiiCall("limitToAccount", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    @Override
    @javax.annotation.Nullable
    public java.lang.Object resolve(final software.amazon.awscdk.IResolveContext _context) {
        return this.jsiiCall("resolve", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(_context, "_context is required") });
    }

    /**
     * Add a condition to the Policy.
     * 
     * @deprecated For backwards compatibility. Use addCondition() instead.
     */
    public software.amazon.awscdk.services.iam.PolicyStatement setCondition(final java.lang.String key, @javax.annotation.Nullable final java.lang.Object value) {
        return this.jsiiCall("setCondition", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    @javax.annotation.Nullable
    public java.lang.Object toJson() {
        return this.jsiiCall("toJson", java.lang.Object.class);
    }

    /**
     * Indicates if this permission has a "Principal" section.
     */
    public java.lang.Boolean getHasPrincipal() {
        return this.jsiiGet("hasPrincipal", java.lang.Boolean.class);
    }

    /**
     * Indicates if this permission as at least one resource associated with it.
     */
    public java.lang.Boolean getHasResource() {
        return this.jsiiGet("hasResource", java.lang.Boolean.class);
    }

    @javax.annotation.Nullable
    public java.lang.String getSid() {
        return this.jsiiGet("sid", java.lang.String.class);
    }

    public void setSid(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("sid", value);
    }
}
