package software.amazon.awscdk.services.iam;

/**
 * Options for a grant operation.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T10:59:51.767Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GrantWithResourceOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.CommonGrantOptions {
    /**
     * The resource with a resource policy.
     * 
     * The statement will be added to the resource policy if it couldn't be
     * added to the principal policy.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.iam.IResourceWithPolicy getResource();
    /**
     * When referring to the resource in a resource policy, use this as ARN.
     * 
     * (Depending on the resource type, this needs to be '*' in a resource policy).
     * 
     * Default: Same as regular resource ARNs
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getResourceSelfArns();

    /**
     * @return a {@link Builder} of {@link GrantWithResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GrantWithResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.iam.IResourceWithPolicy _resource;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _resourceSelfArns;
        private java.util.List<java.lang.String> _actions;
        private software.amazon.awscdk.services.iam.IGrantable _grantee;
        private java.util.List<java.lang.String> _resourceArns;

        /**
         * Sets the value of Resource
         * @param value The resource with a resource policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResource(final software.amazon.awscdk.services.iam.IResourceWithPolicy value) {
            this._resource = java.util.Objects.requireNonNull(value, "resource is required");
            return this;
        }
        /**
         * Sets the value of ResourceSelfArns
         * @param value When referring to the resource in a resource policy, use this as ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResourceSelfArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._resourceSelfArns = value;
            return this;
        }
        /**
         * Sets the value of Actions
         * @param value The actions to grant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withActions(final java.util.List<java.lang.String> value) {
            this._actions = java.util.Objects.requireNonNull(value, "actions is required");
            return this;
        }
        /**
         * Sets the value of Grantee
         * @param value The principal to grant to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withGrantee(final software.amazon.awscdk.services.iam.IGrantable value) {
            this._grantee = java.util.Objects.requireNonNull(value, "grantee is required");
            return this;
        }
        /**
         * Sets the value of ResourceArns
         * @param value The resource ARNs to grant to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResourceArns(final java.util.List<java.lang.String> value) {
            this._resourceArns = java.util.Objects.requireNonNull(value, "resourceArns is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantWithResourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public GrantWithResourceOptions build() {
            return new GrantWithResourceOptions() {
                private final software.amazon.awscdk.services.iam.IResourceWithPolicy $resource = java.util.Objects.requireNonNull(_resource, "resource is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $resourceSelfArns = _resourceSelfArns;
                private final java.util.List<java.lang.String> $actions = java.util.Objects.requireNonNull(_actions, "actions is required");
                private final software.amazon.awscdk.services.iam.IGrantable $grantee = java.util.Objects.requireNonNull(_grantee, "grantee is required");
                private final java.util.List<java.lang.String> $resourceArns = java.util.Objects.requireNonNull(_resourceArns, "resourceArns is required");

                @Override
                public software.amazon.awscdk.services.iam.IResourceWithPolicy getResource() {
                    return this.$resource;
                }

                @Override
                public java.util.List<java.lang.String> getResourceSelfArns() {
                    return this.$resourceSelfArns;
                }

                @Override
                public java.util.List<java.lang.String> getActions() {
                    return this.$actions;
                }

                @Override
                public software.amazon.awscdk.services.iam.IGrantable getGrantee() {
                    return this.$grantee;
                }

                @Override
                public java.util.List<java.lang.String> getResourceArns() {
                    return this.$resourceArns;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("resource", om.valueToTree(this.getResource()));
                    if (this.getResourceSelfArns() != null) {
                        obj.set("resourceSelfArns", om.valueToTree(this.getResourceSelfArns()));
                    }
                    obj.set("actions", om.valueToTree(this.getActions()));
                    obj.set("grantee", om.valueToTree(this.getGrantee()));
                    obj.set("resourceArns", om.valueToTree(this.getResourceArns()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.GrantWithResourceOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The resource with a resource policy.
         * 
         * The statement will be added to the resource policy if it couldn't be
         * added to the principal policy.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.iam.IResourceWithPolicy getResource() {
            return this.jsiiGet("resource", software.amazon.awscdk.services.iam.IResourceWithPolicy.class);
        }

        /**
         * When referring to the resource in a resource policy, use this as ARN.
         * 
         * (Depending on the resource type, this needs to be '*' in a resource policy).
         * 
         * Default: Same as regular resource ARNs
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getResourceSelfArns() {
            return this.jsiiGet("resourceSelfArns", java.util.List.class);
        }

        /**
         * The actions to grant.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<java.lang.String> getActions() {
            return this.jsiiGet("actions", java.util.List.class);
        }

        /**
         * The principal to grant to.
         * 
         * Default: if principal is undefined, no work is done.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.iam.IGrantable getGrantee() {
            return this.jsiiGet("grantee", software.amazon.awscdk.services.iam.IGrantable.class);
        }

        /**
         * The resource ARNs to grant to.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<java.lang.String> getResourceArns() {
            return this.jsiiGet("resourceArns", java.util.List.class);
        }
    }
}
