/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.RoleProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface LazyRoleProps
extends JsiiSerializable,
RoleProps {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IPrincipal _assumedBy;
        @Nullable
        private String _externalId;
        @Nullable
        private Map<String, PolicyDocument> _inlinePolicies;
        @Nullable
        private List<String> _managedPolicyArns;
        @Nullable
        private Number _maxSessionDurationSec;
        @Nullable
        private String _path;
        @Nullable
        private String _roleName;

        public Builder withAssumedBy(IPrincipal value) {
            this._assumedBy = Objects.requireNonNull(value, "assumedBy is required");
            return this;
        }

        public Builder withExternalId(@Nullable String value) {
            this._externalId = value;
            return this;
        }

        public Builder withInlinePolicies(@Nullable Map<String, PolicyDocument> value) {
            this._inlinePolicies = value;
            return this;
        }

        public Builder withManagedPolicyArns(@Nullable List<String> value) {
            this._managedPolicyArns = value;
            return this;
        }

        public Builder withMaxSessionDurationSec(@Nullable Number value) {
            this._maxSessionDurationSec = value;
            return this;
        }

        public Builder withPath(@Nullable String value) {
            this._path = value;
            return this;
        }

        public Builder withRoleName(@Nullable String value) {
            this._roleName = value;
            return this;
        }

        public LazyRoleProps build() {
            return new LazyRoleProps(){
                private final IPrincipal $assumedBy;
                @Nullable
                private final String $externalId;
                @Nullable
                private final Map<String, PolicyDocument> $inlinePolicies;
                @Nullable
                private final List<String> $managedPolicyArns;
                @Nullable
                private final Number $maxSessionDurationSec;
                @Nullable
                private final String $path;
                @Nullable
                private final String $roleName;
                {
                    this.$assumedBy = Objects.requireNonNull(_assumedBy, "assumedBy is required");
                    this.$externalId = _externalId;
                    this.$inlinePolicies = _inlinePolicies;
                    this.$managedPolicyArns = _managedPolicyArns;
                    this.$maxSessionDurationSec = _maxSessionDurationSec;
                    this.$path = _path;
                    this.$roleName = _roleName;
                }

                @Override
                public IPrincipal getAssumedBy() {
                    return this.$assumedBy;
                }

                @Override
                public String getExternalId() {
                    return this.$externalId;
                }

                @Override
                public Map<String, PolicyDocument> getInlinePolicies() {
                    return this.$inlinePolicies;
                }

                @Override
                public List<String> getManagedPolicyArns() {
                    return this.$managedPolicyArns;
                }

                @Override
                public Number getMaxSessionDurationSec() {
                    return this.$maxSessionDurationSec;
                }

                @Override
                public String getPath() {
                    return this.$path;
                }

                @Override
                public String getRoleName() {
                    return this.$roleName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("assumedBy", om.valueToTree((Object)this.getAssumedBy()));
                    if (this.getExternalId() != null) {
                        obj.set("externalId", om.valueToTree((Object)this.getExternalId()));
                    }
                    if (this.getInlinePolicies() != null) {
                        obj.set("inlinePolicies", om.valueToTree(this.getInlinePolicies()));
                    }
                    if (this.getManagedPolicyArns() != null) {
                        obj.set("managedPolicyArns", om.valueToTree(this.getManagedPolicyArns()));
                    }
                    if (this.getMaxSessionDurationSec() != null) {
                        obj.set("maxSessionDurationSec", om.valueToTree((Object)this.getMaxSessionDurationSec()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree((Object)this.getPath()));
                    }
                    if (this.getRoleName() != null) {
                        obj.set("roleName", om.valueToTree((Object)this.getRoleName()));
                    }
                    return obj;
                }
            };
        }
    }
}

