package software.amazon.awscdk.services.iam;

/**
 * A construct that represents an IAM principal, such as a user, group or role.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:53:22.775Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IIdentity extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IPrincipal, software.amazon.awscdk.core.IResource {
    /**
     * Attaches a managed policy to this principal.
     * 
     * EXPERIMENTAL
     * 
     * @param policy The managed policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    void addManagedPolicy(final software.amazon.awscdk.services.iam.IManagedPolicy policy);
    /**
     * Attaches an inline policy to this principal. This is the same as calling `policy.addToXxx(principal)`.
     * 
     * EXPERIMENTAL
     * 
     * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface].
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IIdentity {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getAssumeRoleAction() {
            return this.jsiiGet("assumeRoleAction", java.lang.String.class);
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
        }

        /**
         * The principal to grant permissions to.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * The stack in which this resource is defined.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct node in the tree.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Attaches a managed policy to this principal.
         * 
         * EXPERIMENTAL
         * 
         * @param policy The managed policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public void addManagedPolicy(final software.amazon.awscdk.services.iam.IManagedPolicy policy) {
            this.jsiiCall("addManagedPolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Attaches an inline policy to this principal. This is the same as calling `policy.addToXxx(principal)`.
         * 
         * EXPERIMENTAL
         * 
         * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface].
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
            this.jsiiCall("attachInlinePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add to the policy of this principal.
         * 
         * EXPERIMENTAL
         * 
         * @return true if the statement was added, false if the principal in
         * question does not have a policy document to add the statement to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }
    }
}
