package software.amazon.awscdk.services.iam;

/**
 * Options for a grant operation that only applies to principals.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:28:20.010Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GrantOnPrincipalOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.CommonGrantOptions {
    /**
     * Construct to report warnings on in case grant could not be registered.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.core.IConstruct getScope();

    /**
     * @return a {@link Builder} of {@link GrantOnPrincipalOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GrantOnPrincipalOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.IConstruct _scope;
        private java.util.List<java.lang.String> _actions;
        private software.amazon.awscdk.services.iam.IGrantable _grantee;
        private java.util.List<java.lang.String> _resourceArns;

        /**
         * Sets the value of Scope
         * @param value Construct to report warnings on in case grant could not be registered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withScope(@javax.annotation.Nullable final software.amazon.awscdk.core.IConstruct value) {
            this._scope = value;
            return this;
        }
        /**
         * Sets the value of Actions
         * @param value The actions to grant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withActions(final java.util.List<java.lang.String> value) {
            this._actions = java.util.Objects.requireNonNull(value, "actions is required");
            return this;
        }
        /**
         * Sets the value of Grantee
         * @param value The principal to grant to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withGrantee(final software.amazon.awscdk.services.iam.IGrantable value) {
            this._grantee = java.util.Objects.requireNonNull(value, "grantee is required");
            return this;
        }
        /**
         * Sets the value of ResourceArns
         * @param value The resource ARNs to grant to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResourceArns(final java.util.List<java.lang.String> value) {
            this._resourceArns = java.util.Objects.requireNonNull(value, "resourceArns is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantOnPrincipalOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public GrantOnPrincipalOptions build() {
            return new GrantOnPrincipalOptions() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.IConstruct $scope = _scope;
                private final java.util.List<java.lang.String> $actions = java.util.Objects.requireNonNull(_actions, "actions is required");
                private final software.amazon.awscdk.services.iam.IGrantable $grantee = java.util.Objects.requireNonNull(_grantee, "grantee is required");
                private final java.util.List<java.lang.String> $resourceArns = java.util.Objects.requireNonNull(_resourceArns, "resourceArns is required");

                @Override
                public software.amazon.awscdk.core.IConstruct getScope() {
                    return this.$scope;
                }

                @Override
                public java.util.List<java.lang.String> getActions() {
                    return this.$actions;
                }

                @Override
                public software.amazon.awscdk.services.iam.IGrantable getGrantee() {
                    return this.$grantee;
                }

                @Override
                public java.util.List<java.lang.String> getResourceArns() {
                    return this.$resourceArns;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getScope() != null) {
                        obj.set("scope", om.valueToTree(this.getScope()));
                    }
                    obj.set("actions", om.valueToTree(this.getActions()));
                    obj.set("grantee", om.valueToTree(this.getGrantee()));
                    obj.set("resourceArns", om.valueToTree(this.getResourceArns()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.GrantOnPrincipalOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Construct to report warnings on in case grant could not be registered.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.IConstruct getScope() {
            return this.jsiiGet("scope", software.amazon.awscdk.core.IConstruct.class);
        }

        /**
         * The actions to grant.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<java.lang.String> getActions() {
            return this.jsiiGet("actions", java.util.List.class);
        }

        /**
         * The principal to grant to.
         * 
         * Default: if principal is undefined, no work is done.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.iam.IGrantable getGrantee() {
            return this.jsiiGet("grantee", software.amazon.awscdk.services.iam.IGrantable.class);
        }

        /**
         * The resource ARNs to grant to.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<java.lang.String> getResourceArns() {
            return this.jsiiGet("resourceArns", java.util.List.class);
        }
    }
}
