package software.amazon.awscdk.services.iam;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:28:20.012Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A name for the IAM group.
     * 
     * For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * 
     * Default: Generated by CloudFormation (recommended)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getGroupName();
    /**
     * A list managed policies associated with this role.
     * 
     * You can add managed policies later using `attachManagedPolicy(policy)`.
     * 
     * Default: - No managed policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies();
    /**
     * The path to the group.
     * 
     * For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     * 
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();

    /**
     * @return a {@link Builder} of {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _groupName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> _managedPolicies;
        @javax.annotation.Nullable
        private java.lang.String _path;

        /**
         * Sets the value of GroupName
         * @param value A name for the IAM group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._groupName = value;
            return this;
        }
        /**
         * Sets the value of ManagedPolicies
         * @param value A list managed policies associated with this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withManagedPolicies(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> value) {
            this._managedPolicies = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path to the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public GroupProps build() {
            return new GroupProps() {
                @javax.annotation.Nullable
                private final java.lang.String $groupName = _groupName;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> $managedPolicies = _managedPolicies;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;

                @Override
                public java.lang.String getGroupName() {
                    return this.$groupName;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
                    return this.$managedPolicies;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getGroupName() != null) {
                        obj.set("groupName", om.valueToTree(this.getGroupName()));
                    }
                    if (this.getManagedPolicies() != null) {
                        obj.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree(this.getPath()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.GroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A name for the IAM group.
         * 
         * For valid values, see the GroupName parameter
         * for the CreateGroup action in the IAM API Reference. If you don't specify
         * a name, AWS CloudFormation generates a unique physical ID and uses that
         * ID for the group name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * 
         * Default: Generated by CloudFormation (recommended)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }

        /**
         * A list managed policies associated with this role.
         * 
         * You can add managed policies later using `attachManagedPolicy(policy)`.
         * 
         * Default: - No managed policies.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
            return this.jsiiGet("managedPolicies", java.util.List.class);
        }

        /**
         * The path to the group.
         * 
         * For more information about paths, see [IAM
         * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
         * in the IAM User Guide.
         * 
         * Default: /
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }
    }
}
