package software.amazon.awscdk.services.iam;
public interface GroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A name for the IAM group. For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * @default Generated by CloudFormation (recommended)
     */
    java.lang.String getGroupName();
    /**
     * A name for the IAM group. For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * @default Generated by CloudFormation (recommended)
     */
    void setGroupName(final java.lang.String value);
    /**
     * A list of ARNs for managed policies associated with group.
     * @default No managed policies.
     */
    java.util.List<java.lang.Object> getManagedPolicyArns();
    /**
     * A list of ARNs for managed policies associated with group.
     * @default No managed policies.
     */
    void setManagedPolicyArns(final java.util.List<java.lang.Object> value);
    /**
     * The path to the group. For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     */
    java.lang.String getPath();
    /**
     * The path to the group. For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     */
    void setPath(final java.lang.String value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link GroupProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * A name for the IAM group. For valid values, see the GroupName parameter
         * for the CreateGroup action in the IAM API Reference. If you don't specify
         * a name, AWS CloudFormation generates a unique physical ID and uses that
         * ID for the group name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @default Generated by CloudFormation (recommended)
         */
        public Builder withGroupName(final java.lang.String value) {
            this.instance._groupName = value;
            return this;
        }
        /**
         * A list of ARNs for managed policies associated with group.
         * @default No managed policies.
         */
        public Builder withManagedPolicyArns(final java.util.List<java.lang.Object> value) {
            this.instance._managedPolicyArns = value;
            return this;
        }
        /**
         * The path to the group. For more information about paths, see [IAM
         * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
         * in the IAM User Guide.
         */
        public Builder withPath(final java.lang.String value) {
            this.instance._path = value;
            return this;
        }
        public GroupProps build() {
            GroupProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link GroupProps}.
     */
    final class Jsii$Pojo implements GroupProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _groupName;

        public java.lang.String getGroupName() {
            return this._groupName;
        }
        public void setGroupName(final java.lang.String value) {
            this._groupName = value;
        }

        protected java.util.List<java.lang.Object> _managedPolicyArns;

        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this._managedPolicyArns;
        }
        public void setManagedPolicyArns(final java.util.List<java.lang.Object> value) {
            this._managedPolicyArns = value;
        }

        protected java.lang.String _path;

        public java.lang.String getPath() {
            return this._path;
        }
        public void setPath(final java.lang.String value) {
            this._path = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.GroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * A name for the IAM group. For valid values, see the GroupName parameter
         * for the CreateGroup action in the IAM API Reference. If you don't specify
         * a name, AWS CloudFormation generates a unique physical ID and uses that
         * ID for the group name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @default Generated by CloudFormation (recommended)
         */
        @javax.annotation.Nullable
        public java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }
        /**
         * A name for the IAM group. For valid values, see the GroupName parameter
         * for the CreateGroup action in the IAM API Reference. If you don't specify
         * a name, AWS CloudFormation generates a unique physical ID and uses that
         * ID for the group name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @default Generated by CloudFormation (recommended)
         */
        public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("groupName", value);
        }
        /**
         * A list of ARNs for managed policies associated with group.
         * @default No managed policies.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this.jsiiGet("managedPolicyArns", java.util.List.class);
        }
        /**
         * A list of ARNs for managed policies associated with group.
         * @default No managed policies.
         */
        public void setManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("managedPolicyArns", value);
        }
        /**
         * The path to the group. For more information about paths, see [IAM
         * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
         * in the IAM User Guide.
         */
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }
        /**
         * The path to the group. For more information about paths, see [IAM
         * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
         * in the IAM User Guide.
         */
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }
    }
}
