package software.amazon.awscdk.services.iam;
public interface RoleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
     * which can assume this role.
     * 
     * You can later modify the assume role policy document by accessing it via
     * the `assumeRolePolicy` property.
     */
    software.amazon.awscdk.PolicyPrincipal getAssumedBy();
    /**
     * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
     * which can assume this role.
     * 
     * You can later modify the assume role policy document by accessing it via
     * the `assumeRolePolicy` property.
     */
    void setAssumedBy(final software.amazon.awscdk.PolicyPrincipal value);
    /**
     * A list of ARNs for managed policies associated with this role.
     * You can add managed policies later using `addManagedPolicy(arn)`.
     * @default No managed policies.
     */
    java.util.List<java.lang.Object> getManagedPolicyArns();
    /**
     * A list of ARNs for managed policies associated with this role.
     * You can add managed policies later using `addManagedPolicy(arn)`.
     * @default No managed policies.
     */
    void setManagedPolicyArns(final java.util.List<java.lang.Object> value);
    /**
     * The path associated with this role. For information about IAM paths, see
     * Friendly Names and Paths in IAM User Guide.
     */
    java.lang.String getPath();
    /**
     * The path associated with this role. For information about IAM paths, see
     * Friendly Names and Paths in IAM User Guide.
     */
    void setPath(final java.lang.String value);
    /**
     * A name for the IAM role. For valid values, see the RoleName parameter for
     * the CreateRole action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the group name.
     * 
     * IMPORTANT: If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     */
    java.lang.String getRoleName();
    /**
     * A name for the IAM role. For valid values, see the RoleName parameter for
     * the CreateRole action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the group name.
     * 
     * IMPORTANT: If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     */
    void setRoleName(final java.lang.String value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link RoleProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
         * which can assume this role.
         * 
         * You can later modify the assume role policy document by accessing it via
         * the `assumeRolePolicy` property.
         */
        public Build withAssumedBy(final software.amazon.awscdk.PolicyPrincipal value) {
            return new FullBuilder().withAssumedBy(value);
        }

        public interface Build {
            /**
             * @return a new {@link RoleProps} object, initialized with the values set on this builder.
             */
            RoleProps build();
            /**
             * A list of ARNs for managed policies associated with this role.
             * You can add managed policies later using `addManagedPolicy(arn)`.
             * @default No managed policies.
             */
            Build withManagedPolicyArns(final java.util.List<java.lang.Object> value);
            /**
             * The path associated with this role. For information about IAM paths, see
             * Friendly Names and Paths in IAM User Guide.
             */
            Build withPath(final java.lang.String value);
            /**
             * A name for the IAM role. For valid values, see the RoleName parameter for
             * the CreateRole action in the IAM API Reference. If you don't specify a
             * name, AWS CloudFormation generates a unique physical ID and uses that ID
             * for the group name.
             * 
             * IMPORTANT: If you specify a name, you cannot perform updates that require
             * replacement of this resource. You can perform updates that require no or
             * some interruption. If you must replace the resource, specify a new name.
             * 
             * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
             * acknowledge your template's capabilities. For more information, see
             * Acknowledging IAM Resources in AWS CloudFormation Templates.
             */
            Build withRoleName(final java.lang.String value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
             * which can assume this role.
             * 
             * You can later modify the assume role policy document by accessing it via
             * the `assumeRolePolicy` property.
             */
            public Build withAssumedBy(final software.amazon.awscdk.PolicyPrincipal value) {
                java.util.Objects.requireNonNull(value, "RoleProps#assumedBy is required");
                this.instance._assumedBy = value;
                return this;
            }
            /**
             * A list of ARNs for managed policies associated with this role.
             * You can add managed policies later using `addManagedPolicy(arn)`.
             * @default No managed policies.
             */
            public Build withManagedPolicyArns(final java.util.List<java.lang.Object> value) {
                this.instance._managedPolicyArns = value;
                return this;
            }
            /**
             * The path associated with this role. For information about IAM paths, see
             * Friendly Names and Paths in IAM User Guide.
             */
            public Build withPath(final java.lang.String value) {
                this.instance._path = value;
                return this;
            }
            /**
             * A name for the IAM role. For valid values, see the RoleName parameter for
             * the CreateRole action in the IAM API Reference. If you don't specify a
             * name, AWS CloudFormation generates a unique physical ID and uses that ID
             * for the group name.
             * 
             * IMPORTANT: If you specify a name, you cannot perform updates that require
             * replacement of this resource. You can perform updates that require no or
             * some interruption. If you must replace the resource, specify a new name.
             * 
             * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
             * acknowledge your template's capabilities. For more information, see
             * Acknowledging IAM Resources in AWS CloudFormation Templates.
             */
            public Build withRoleName(final java.lang.String value) {
                this.instance._roleName = value;
                return this;
            }
            public RoleProps build() {
                RoleProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link RoleProps}.
     */
    final class Jsii$Pojo implements RoleProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.PolicyPrincipal _assumedBy;

        public software.amazon.awscdk.PolicyPrincipal getAssumedBy() {
            return this._assumedBy;
        }
        public void setAssumedBy(final software.amazon.awscdk.PolicyPrincipal value) {
            this._assumedBy = value;
        }

        protected java.util.List<java.lang.Object> _managedPolicyArns;

        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this._managedPolicyArns;
        }
        public void setManagedPolicyArns(final java.util.List<java.lang.Object> value) {
            this._managedPolicyArns = value;
        }

        protected java.lang.String _path;

        public java.lang.String getPath() {
            return this._path;
        }
        public void setPath(final java.lang.String value) {
            this._path = value;
        }

        protected java.lang.String _roleName;

        public java.lang.String getRoleName() {
            return this._roleName;
        }
        public void setRoleName(final java.lang.String value) {
            this._roleName = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.RoleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
         * which can assume this role.
         * 
         * You can later modify the assume role policy document by accessing it via
         * the `assumeRolePolicy` property.
         */
        public software.amazon.awscdk.PolicyPrincipal getAssumedBy() {
            return this.jsiiGet("assumedBy", software.amazon.awscdk.PolicyPrincipal.class);
        }
        /**
         * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`)
         * which can assume this role.
         * 
         * You can later modify the assume role policy document by accessing it via
         * the `assumeRolePolicy` property.
         */
        public void setAssumedBy(final software.amazon.awscdk.PolicyPrincipal value) {
            this.jsiiSet("assumedBy", java.util.Objects.requireNonNull(value, "assumedBy is required"));
        }
        /**
         * A list of ARNs for managed policies associated with this role.
         * You can add managed policies later using `addManagedPolicy(arn)`.
         * @default No managed policies.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this.jsiiGet("managedPolicyArns", java.util.List.class);
        }
        /**
         * A list of ARNs for managed policies associated with this role.
         * You can add managed policies later using `addManagedPolicy(arn)`.
         * @default No managed policies.
         */
        public void setManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("managedPolicyArns", value);
        }
        /**
         * The path associated with this role. For information about IAM paths, see
         * Friendly Names and Paths in IAM User Guide.
         */
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }
        /**
         * The path associated with this role. For information about IAM paths, see
         * Friendly Names and Paths in IAM User Guide.
         */
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }
        /**
         * A name for the IAM role. For valid values, see the RoleName parameter for
         * the CreateRole action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the group name.
         * 
         * IMPORTANT: If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         */
        @javax.annotation.Nullable
        public java.lang.String getRoleName() {
            return this.jsiiGet("roleName", java.lang.String.class);
        }
        /**
         * A name for the IAM role. For valid values, see the RoleName parameter for
         * the CreateRole action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the group name.
         * 
         * IMPORTANT: If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         */
        public void setRoleName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("roleName", value);
        }
    }
}
