package software.amazon.awscdk.services.iam;
public interface UserProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Groups to add this user to. You can also use `addToGroup` to add this
     * user to a group.
     */
    java.util.List<software.amazon.awscdk.services.iam.Group> getGroups();
    /**
     * Groups to add this user to. You can also use `addToGroup` to add this
     * user to a group.
     */
    void setGroups(final java.util.List<software.amazon.awscdk.services.iam.Group> value);
    /**
     * A list of ARNs for managed policies attacherd to this user.
     * You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
     * @default No managed policies.
     */
    java.util.List<java.lang.Object> getManagedPolicyArns();
    /**
     * A list of ARNs for managed policies attacherd to this user.
     * You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
     * @default No managed policies.
     */
    void setManagedPolicyArns(final java.util.List<java.lang.Object> value);
    /**
     * The path for the user name. For more information about paths, see IAM
     * Identifiers in the IAM User Guide.
     */
    java.lang.String getPath();
    /**
     * The path for the user name. For more information about paths, see IAM
     * Identifiers in the IAM User Guide.
     */
    void setPath(final java.lang.String value);
    /**
     * A name for the IAM user. For valid values, see the UserName parameter for
     * the CreateUser action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the user name.
     * 
     * If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * @default Generated by CloudFormation (recommended)
     */
    java.lang.String getUserName();
    /**
     * A name for the IAM user. For valid values, see the UserName parameter for
     * the CreateUser action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the user name.
     * 
     * If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * @default Generated by CloudFormation (recommended)
     */
    void setUserName(final java.lang.String value);
    /**
     * The password for the user. This is required so the user can access the
     * AWS Management Console.
     * @default User won't be able to access the management console without a password.
     */
    java.lang.String getPassword();
    /**
     * The password for the user. This is required so the user can access the
     * AWS Management Console.
     * @default User won't be able to access the management console without a password.
     */
    void setPassword(final java.lang.String value);
    /**
     * Specifies whether the user is required to set a new password the next
     * time the user logs in to the AWS Management Console.
     * 
     * If this is set to 'true', you must also specify "initialPassword".
     * @default false
     */
    java.lang.Boolean getPasswordResetRequired();
    /**
     * Specifies whether the user is required to set a new password the next
     * time the user logs in to the AWS Management Console.
     * 
     * If this is set to 'true', you must also specify "initialPassword".
     * @default false
     */
    void setPasswordResetRequired(final java.lang.Boolean value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link UserProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * Groups to add this user to. You can also use `addToGroup` to add this
         * user to a group.
         */
        public Builder withGroups(final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this.instance._groups = value;
            return this;
        }
        /**
         * A list of ARNs for managed policies attacherd to this user.
         * You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
         * @default No managed policies.
         */
        public Builder withManagedPolicyArns(final java.util.List<java.lang.Object> value) {
            this.instance._managedPolicyArns = value;
            return this;
        }
        /**
         * The path for the user name. For more information about paths, see IAM
         * Identifiers in the IAM User Guide.
         */
        public Builder withPath(final java.lang.String value) {
            this.instance._path = value;
            return this;
        }
        /**
         * A name for the IAM user. For valid values, see the UserName parameter for
         * the CreateUser action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the user name.
         * 
         * If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @default Generated by CloudFormation (recommended)
         */
        public Builder withUserName(final java.lang.String value) {
            this.instance._userName = value;
            return this;
        }
        /**
         * The password for the user. This is required so the user can access the
         * AWS Management Console.
         * @default User won't be able to access the management console without a password.
         */
        public Builder withPassword(final java.lang.String value) {
            this.instance._password = value;
            return this;
        }
        /**
         * Specifies whether the user is required to set a new password the next
         * time the user logs in to the AWS Management Console.
         * 
         * If this is set to 'true', you must also specify "initialPassword".
         * @default false
         */
        public Builder withPasswordResetRequired(final java.lang.Boolean value) {
            this.instance._passwordResetRequired = value;
            return this;
        }
        public UserProps build() {
            UserProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link UserProps}.
     */
    final class Jsii$Pojo implements UserProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.util.List<software.amazon.awscdk.services.iam.Group> _groups;

        public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
            return this._groups;
        }
        public void setGroups(final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this._groups = value;
        }

        protected java.util.List<java.lang.Object> _managedPolicyArns;

        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this._managedPolicyArns;
        }
        public void setManagedPolicyArns(final java.util.List<java.lang.Object> value) {
            this._managedPolicyArns = value;
        }

        protected java.lang.String _path;

        public java.lang.String getPath() {
            return this._path;
        }
        public void setPath(final java.lang.String value) {
            this._path = value;
        }

        protected java.lang.String _userName;

        public java.lang.String getUserName() {
            return this._userName;
        }
        public void setUserName(final java.lang.String value) {
            this._userName = value;
        }

        protected java.lang.String _password;

        public java.lang.String getPassword() {
            return this._password;
        }
        public void setPassword(final java.lang.String value) {
            this._password = value;
        }

        protected java.lang.Boolean _passwordResetRequired;

        public java.lang.Boolean getPasswordResetRequired() {
            return this._passwordResetRequired;
        }
        public void setPasswordResetRequired(final java.lang.Boolean value) {
            this._passwordResetRequired = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.UserProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * Groups to add this user to. You can also use `addToGroup` to add this
         * user to a group.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
            return this.jsiiGet("groups", java.util.List.class);
        }
        /**
         * Groups to add this user to. You can also use `addToGroup` to add this
         * user to a group.
         */
        public void setGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this.jsiiSet("groups", value);
        }
        /**
         * A list of ARNs for managed policies attacherd to this user.
         * You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
         * @default No managed policies.
         */
        @javax.annotation.Nullable
        public java.util.List<java.lang.Object> getManagedPolicyArns() {
            return this.jsiiGet("managedPolicyArns", java.util.List.class);
        }
        /**
         * A list of ARNs for managed policies attacherd to this user.
         * You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
         * @default No managed policies.
         */
        public void setManagedPolicyArns(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("managedPolicyArns", value);
        }
        /**
         * The path for the user name. For more information about paths, see IAM
         * Identifiers in the IAM User Guide.
         */
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }
        /**
         * The path for the user name. For more information about paths, see IAM
         * Identifiers in the IAM User Guide.
         */
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }
        /**
         * A name for the IAM user. For valid values, see the UserName parameter for
         * the CreateUser action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the user name.
         * 
         * If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @default Generated by CloudFormation (recommended)
         */
        @javax.annotation.Nullable
        public java.lang.String getUserName() {
            return this.jsiiGet("userName", java.lang.String.class);
        }
        /**
         * A name for the IAM user. For valid values, see the UserName parameter for
         * the CreateUser action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the user name.
         * 
         * If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @default Generated by CloudFormation (recommended)
         */
        public void setUserName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("userName", value);
        }
        /**
         * The password for the user. This is required so the user can access the
         * AWS Management Console.
         * @default User won't be able to access the management console without a password.
         */
        @javax.annotation.Nullable
        public java.lang.String getPassword() {
            return this.jsiiGet("password", java.lang.String.class);
        }
        /**
         * The password for the user. This is required so the user can access the
         * AWS Management Console.
         * @default User won't be able to access the management console without a password.
         */
        public void setPassword(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("password", value);
        }
        /**
         * Specifies whether the user is required to set a new password the next
         * time the user logs in to the AWS Management Console.
         * 
         * If this is set to 'true', you must also specify "initialPassword".
         * @default false
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getPasswordResetRequired() {
            return this.jsiiGet("passwordResetRequired", java.lang.Boolean.class);
        }
        /**
         * Specifies whether the user is required to set a new password the next
         * time the user logs in to the AWS Management Console.
         * 
         * If this is set to 'true', you must also specify "initialPassword".
         * @default false
         */
        public void setPasswordResetRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("passwordResetRequired", value);
        }
    }
}
