package software.amazon.awscdk.services.iam.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.cloudformation.RoleResource")
public class RoleResource extends software.amazon.awscdk.Resource {
    protected RoleResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.cloudformation.RoleResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::IAM::Role``.
     * @param parent the ``cdk.Construct`` this ``RoleResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``RoleResource``
     */
    public RoleResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.iam.cloudformation.RoleResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Arn
     */
    public software.amazon.awscdk.services.iam.RoleArn getRoleArn() {
        return this.jsiiGet("roleArn", software.amazon.awscdk.services.iam.RoleArn.class);
    }
    /**
     * @cloudformation_attribute RoleId
     */
    public software.amazon.awscdk.services.iam.RoleId getRoleId() {
        return this.jsiiGet("roleId", software.amazon.awscdk.services.iam.RoleId.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    public static interface PolicyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RoleResource.PolicyProperty.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        java.lang.Object getPolicyDocument();
        /**
         * ``RoleResource.PolicyProperty.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value);
        /**
         * ``RoleResource.PolicyProperty.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        void setPolicyDocument(final software.amazon.awscdk.Token value);
        /**
         * ``RoleResource.PolicyProperty.PolicyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        java.lang.Object getPolicyName();
        /**
         * ``RoleResource.PolicyProperty.PolicyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        void setPolicyName(final java.lang.String value);
        /**
         * ``RoleResource.PolicyProperty.PolicyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        void setPolicyName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link PolicyProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``RoleResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public PolicyNameStep withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                return new FullBuilder().withPolicyDocument(value);
            }
            /**
             * ``RoleResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public PolicyNameStep withPolicyDocument(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPolicyDocument(value);
            }

            public interface PolicyNameStep {
                /**
                 * ``RoleResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                Build withPolicyName(final java.lang.String value);
                /**
                 * ``RoleResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                Build withPolicyName(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link PolicyProperty} object, initialized with the values set on this builder.
                 */
                PolicyProperty build();
            }

            final class FullBuilder implements PolicyNameStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``RoleResource.PolicyProperty.PolicyDocument``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
                 */
                public PolicyNameStep withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyDocument is required");
                    this.instance._policyDocument = value;
                    return this;
                }
                /**
                 * ``RoleResource.PolicyProperty.PolicyDocument``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
                 */
                public PolicyNameStep withPolicyDocument(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyDocument is required");
                    this.instance._policyDocument = value;
                    return this;
                }
                /**
                 * ``RoleResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                public Build withPolicyName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyName is required");
                    this.instance._policyName = value;
                    return this;
                }
                /**
                 * ``RoleResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                public Build withPolicyName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyName is required");
                    this.instance._policyName = value;
                    return this;
                }
                public PolicyProperty build() {
                    PolicyProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PolicyProperty}.
         */
        final class Jsii$Pojo implements PolicyProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _policyDocument;

            public java.lang.Object getPolicyDocument() {
                return this._policyDocument;
            }
            public void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._policyDocument = value;
            }
            public void setPolicyDocument(final software.amazon.awscdk.Token value) {
                this._policyDocument = value;
            }

            protected java.lang.Object _policyName;

            public java.lang.Object getPolicyName() {
                return this._policyName;
            }
            public void setPolicyName(final java.lang.String value) {
                this._policyName = value;
            }
            public void setPolicyName(final software.amazon.awscdk.Token value) {
                this._policyName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.cloudformation.RoleResource.PolicyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RoleResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public java.lang.Object getPolicyDocument() {
                return this.jsiiGet("policyDocument", java.lang.Object.class);
            }
            /**
             * ``RoleResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this.jsiiSet("policyDocument", java.util.Objects.requireNonNull(value, "policyDocument is required"));
            }
            /**
             * ``RoleResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public void setPolicyDocument(final software.amazon.awscdk.Token value) {
                this.jsiiSet("policyDocument", java.util.Objects.requireNonNull(value, "policyDocument is required"));
            }
            /**
             * ``RoleResource.PolicyProperty.PolicyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            public java.lang.Object getPolicyName() {
                return this.jsiiGet("policyName", java.lang.Object.class);
            }
            /**
             * ``RoleResource.PolicyProperty.PolicyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            public void setPolicyName(final java.lang.String value) {
                this.jsiiSet("policyName", java.util.Objects.requireNonNull(value, "policyName is required"));
            }
            /**
             * ``RoleResource.PolicyProperty.PolicyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            public void setPolicyName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("policyName", java.util.Objects.requireNonNull(value, "policyName is required"));
            }
        }
    }
}
