package software.amazon.awscdk.services.iam;
public interface PolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the policy. If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
     */
    java.lang.String getPolicyName();
    /**
     * The name of the policy. If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
     */
    void setPolicyName(final java.lang.String value);
    /**
     * Users to attach this policy to.
     * You can also use `attachToUser(user)` to attach this policy to a user.
     */
    java.util.List<software.amazon.awscdk.services.iam.User> getUsers();
    /**
     * Users to attach this policy to.
     * You can also use `attachToUser(user)` to attach this policy to a user.
     */
    void setUsers(final java.util.List<software.amazon.awscdk.services.iam.User> value);
    /**
     * Roles to attach this policy to.
     * You can also use `attachToRole(role)` to attach this policy to a role.
     */
    java.util.List<software.amazon.awscdk.services.iam.Role> getRoles();
    /**
     * Roles to attach this policy to.
     * You can also use `attachToRole(role)` to attach this policy to a role.
     */
    void setRoles(final java.util.List<software.amazon.awscdk.services.iam.Role> value);
    /**
     * Groups to attach this policy to.
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     */
    java.util.List<software.amazon.awscdk.services.iam.Group> getGroups();
    /**
     * Groups to attach this policy to.
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     */
    void setGroups(final java.util.List<software.amazon.awscdk.services.iam.Group> value);
    /**
     * Initial set of permissions to add to this policy document.
     * You can also use `addPermission(statement)` to add permissions later.
     */
    java.util.List<software.amazon.awscdk.PolicyStatement> getStatements();
    /**
     * Initial set of permissions to add to this policy document.
     * You can also use `addPermission(statement)` to add permissions later.
     */
    void setStatements(final java.util.List<software.amazon.awscdk.PolicyStatement> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link PolicyProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * The name of the policy. If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
         */
        public Builder withPolicyName(final java.lang.String value) {
            this.instance._policyName = value;
            return this;
        }
        /**
         * Users to attach this policy to.
         * You can also use `attachToUser(user)` to attach this policy to a user.
         */
        public Builder withUsers(final java.util.List<software.amazon.awscdk.services.iam.User> value) {
            this.instance._users = value;
            return this;
        }
        /**
         * Roles to attach this policy to.
         * You can also use `attachToRole(role)` to attach this policy to a role.
         */
        public Builder withRoles(final java.util.List<software.amazon.awscdk.services.iam.Role> value) {
            this.instance._roles = value;
            return this;
        }
        /**
         * Groups to attach this policy to.
         * You can also use `attachToGroup(group)` to attach this policy to a group.
         */
        public Builder withGroups(final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this.instance._groups = value;
            return this;
        }
        /**
         * Initial set of permissions to add to this policy document.
         * You can also use `addPermission(statement)` to add permissions later.
         */
        public Builder withStatements(final java.util.List<software.amazon.awscdk.PolicyStatement> value) {
            this.instance._statements = value;
            return this;
        }
        public PolicyProps build() {
            PolicyProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link PolicyProps}.
     */
    final class Jsii$Pojo implements PolicyProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _policyName;

        public java.lang.String getPolicyName() {
            return this._policyName;
        }
        public void setPolicyName(final java.lang.String value) {
            this._policyName = value;
        }

        protected java.util.List<software.amazon.awscdk.services.iam.User> _users;

        public java.util.List<software.amazon.awscdk.services.iam.User> getUsers() {
            return this._users;
        }
        public void setUsers(final java.util.List<software.amazon.awscdk.services.iam.User> value) {
            this._users = value;
        }

        protected java.util.List<software.amazon.awscdk.services.iam.Role> _roles;

        public java.util.List<software.amazon.awscdk.services.iam.Role> getRoles() {
            return this._roles;
        }
        public void setRoles(final java.util.List<software.amazon.awscdk.services.iam.Role> value) {
            this._roles = value;
        }

        protected java.util.List<software.amazon.awscdk.services.iam.Group> _groups;

        public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
            return this._groups;
        }
        public void setGroups(final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this._groups = value;
        }

        protected java.util.List<software.amazon.awscdk.PolicyStatement> _statements;

        public java.util.List<software.amazon.awscdk.PolicyStatement> getStatements() {
            return this._statements;
        }
        public void setStatements(final java.util.List<software.amazon.awscdk.PolicyStatement> value) {
            this._statements = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.PolicyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The name of the policy. If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
         */
        @javax.annotation.Nullable
        public java.lang.String getPolicyName() {
            return this.jsiiGet("policyName", java.lang.String.class);
        }
        /**
         * The name of the policy. If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
         */
        public void setPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("policyName", value);
        }
        /**
         * Users to attach this policy to.
         * You can also use `attachToUser(user)` to attach this policy to a user.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.User> getUsers() {
            return this.jsiiGet("users", java.util.List.class);
        }
        /**
         * Users to attach this policy to.
         * You can also use `attachToUser(user)` to attach this policy to a user.
         */
        public void setUsers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.User> value) {
            this.jsiiSet("users", value);
        }
        /**
         * Roles to attach this policy to.
         * You can also use `attachToRole(role)` to attach this policy to a role.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.Role> getRoles() {
            return this.jsiiGet("roles", java.util.List.class);
        }
        /**
         * Roles to attach this policy to.
         * You can also use `attachToRole(role)` to attach this policy to a role.
         */
        public void setRoles(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Role> value) {
            this.jsiiSet("roles", value);
        }
        /**
         * Groups to attach this policy to.
         * You can also use `attachToGroup(group)` to attach this policy to a group.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
            return this.jsiiGet("groups", java.util.List.class);
        }
        /**
         * Groups to attach this policy to.
         * You can also use `attachToGroup(group)` to attach this policy to a group.
         */
        public void setGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this.jsiiSet("groups", value);
        }
        /**
         * Initial set of permissions to add to this policy document.
         * You can also use `addPermission(statement)` to add permissions later.
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.PolicyStatement> getStatements() {
            return this.jsiiGet("statements", java.util.List.class);
        }
        /**
         * Initial set of permissions to add to this policy document.
         * You can also use `addPermission(statement)` to add permissions later.
         */
        public void setStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.PolicyStatement> value) {
            this.jsiiSet("statements", value);
        }
    }
}
