package software.amazon.awscdk.services.iam.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.cloudformation.UserResource")
public class UserResource extends software.amazon.awscdk.Resource {
    protected UserResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.cloudformation.UserResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::IAM::User``.
     * @param parent the ``cdk.Construct`` this ``UserResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``UserResource``
     */
    public UserResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.iam.cloudformation.UserResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::IAM::User``.
     * @param parent the ``cdk.Construct`` this ``UserResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public UserResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Arn
     */
    public software.amazon.awscdk.services.iam.UserArn getUserArn() {
        return this.jsiiGet("userArn", software.amazon.awscdk.services.iam.UserArn.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html
     */
    public static interface LoginProfileProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``UserResource.LoginProfileProperty.Password``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
         */
        java.lang.Object getPassword();
        /**
         * ``UserResource.LoginProfileProperty.Password``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
         */
        void setPassword(final java.lang.String value);
        /**
         * ``UserResource.LoginProfileProperty.Password``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
         */
        void setPassword(final software.amazon.awscdk.Token value);
        /**
         * ``UserResource.LoginProfileProperty.PasswordResetRequired``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
         */
        java.lang.Object getPasswordResetRequired();
        /**
         * ``UserResource.LoginProfileProperty.PasswordResetRequired``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
         */
        void setPasswordResetRequired(final java.lang.Boolean value);
        /**
         * ``UserResource.LoginProfileProperty.PasswordResetRequired``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
         */
        void setPasswordResetRequired(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link LoginProfileProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``UserResource.LoginProfileProperty.Password``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
             */
            public Build withPassword(final java.lang.String value) {
                return new FullBuilder().withPassword(value);
            }
            /**
             * ``UserResource.LoginProfileProperty.Password``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
             */
            public Build withPassword(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPassword(value);
            }

            public interface Build {
                /**
                 * @return a new {@link LoginProfileProperty} object, initialized with the values set on this builder.
                 */
                LoginProfileProperty build();
                /**
                 * ``UserResource.LoginProfileProperty.PasswordResetRequired``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
                 */
                Build withPasswordResetRequired(final java.lang.Boolean value);
                /**
                 * ``UserResource.LoginProfileProperty.PasswordResetRequired``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
                 */
                Build withPasswordResetRequired(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``UserResource.LoginProfileProperty.Password``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
                 */
                public Build withPassword(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "LoginProfileProperty#password is required");
                    this.instance._password = value;
                    return this;
                }
                /**
                 * ``UserResource.LoginProfileProperty.Password``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
                 */
                public Build withPassword(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LoginProfileProperty#password is required");
                    this.instance._password = value;
                    return this;
                }
                /**
                 * ``UserResource.LoginProfileProperty.PasswordResetRequired``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
                 */
                public Build withPasswordResetRequired(final java.lang.Boolean value) {
                    this.instance._passwordResetRequired = value;
                    return this;
                }
                /**
                 * ``UserResource.LoginProfileProperty.PasswordResetRequired``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
                 */
                public Build withPasswordResetRequired(final software.amazon.awscdk.Token value) {
                    this.instance._passwordResetRequired = value;
                    return this;
                }
                public LoginProfileProperty build() {
                    LoginProfileProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LoginProfileProperty}.
         */
        final class Jsii$Pojo implements LoginProfileProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _password;

            public java.lang.Object getPassword() {
                return this._password;
            }
            public void setPassword(final java.lang.String value) {
                this._password = value;
            }
            public void setPassword(final software.amazon.awscdk.Token value) {
                this._password = value;
            }

            protected java.lang.Object _passwordResetRequired;

            public java.lang.Object getPasswordResetRequired() {
                return this._passwordResetRequired;
            }
            public void setPasswordResetRequired(final java.lang.Boolean value) {
                this._passwordResetRequired = value;
            }
            public void setPasswordResetRequired(final software.amazon.awscdk.Token value) {
                this._passwordResetRequired = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.cloudformation.UserResource.LoginProfileProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``UserResource.LoginProfileProperty.Password``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
             */
            public java.lang.Object getPassword() {
                return this.jsiiGet("password", java.lang.Object.class);
            }
            /**
             * ``UserResource.LoginProfileProperty.Password``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
             */
            public void setPassword(final java.lang.String value) {
                this.jsiiSet("password", java.util.Objects.requireNonNull(value, "password is required"));
            }
            /**
             * ``UserResource.LoginProfileProperty.Password``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-password
             */
            public void setPassword(final software.amazon.awscdk.Token value) {
                this.jsiiSet("password", java.util.Objects.requireNonNull(value, "password is required"));
            }
            /**
             * ``UserResource.LoginProfileProperty.PasswordResetRequired``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
             */
            @javax.annotation.Nullable
            public java.lang.Object getPasswordResetRequired() {
                return this.jsiiGet("passwordResetRequired", java.lang.Object.class);
            }
            /**
             * ``UserResource.LoginProfileProperty.PasswordResetRequired``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
             */
            public void setPasswordResetRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("passwordResetRequired", value);
            }
            /**
             * ``UserResource.LoginProfileProperty.PasswordResetRequired``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user-loginprofile.html#cfn-iam-user-loginprofile-passwordresetrequired
             */
            public void setPasswordResetRequired(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("passwordResetRequired", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html
     */
    public static interface PolicyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``UserResource.PolicyProperty.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        java.lang.Object getPolicyDocument();
        /**
         * ``UserResource.PolicyProperty.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value);
        /**
         * ``UserResource.PolicyProperty.PolicyDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
         */
        void setPolicyDocument(final software.amazon.awscdk.Token value);
        /**
         * ``UserResource.PolicyProperty.PolicyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        java.lang.Object getPolicyName();
        /**
         * ``UserResource.PolicyProperty.PolicyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        void setPolicyName(final java.lang.String value);
        /**
         * ``UserResource.PolicyProperty.PolicyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
         */
        void setPolicyName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link PolicyProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``UserResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public PolicyNameStep withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                return new FullBuilder().withPolicyDocument(value);
            }
            /**
             * ``UserResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public PolicyNameStep withPolicyDocument(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withPolicyDocument(value);
            }

            public interface PolicyNameStep {
                /**
                 * ``UserResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                Build withPolicyName(final java.lang.String value);
                /**
                 * ``UserResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                Build withPolicyName(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link PolicyProperty} object, initialized with the values set on this builder.
                 */
                PolicyProperty build();
            }

            final class FullBuilder implements PolicyNameStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``UserResource.PolicyProperty.PolicyDocument``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
                 */
                public PolicyNameStep withPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyDocument is required");
                    this.instance._policyDocument = value;
                    return this;
                }
                /**
                 * ``UserResource.PolicyProperty.PolicyDocument``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
                 */
                public PolicyNameStep withPolicyDocument(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyDocument is required");
                    this.instance._policyDocument = value;
                    return this;
                }
                /**
                 * ``UserResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                public Build withPolicyName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyName is required");
                    this.instance._policyName = value;
                    return this;
                }
                /**
                 * ``UserResource.PolicyProperty.PolicyName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
                 */
                public Build withPolicyName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "PolicyProperty#policyName is required");
                    this.instance._policyName = value;
                    return this;
                }
                public PolicyProperty build() {
                    PolicyProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PolicyProperty}.
         */
        final class Jsii$Pojo implements PolicyProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _policyDocument;

            public java.lang.Object getPolicyDocument() {
                return this._policyDocument;
            }
            public void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this._policyDocument = value;
            }
            public void setPolicyDocument(final software.amazon.awscdk.Token value) {
                this._policyDocument = value;
            }

            protected java.lang.Object _policyName;

            public java.lang.Object getPolicyName() {
                return this._policyName;
            }
            public void setPolicyName(final java.lang.String value) {
                this._policyName = value;
            }
            public void setPolicyName(final software.amazon.awscdk.Token value) {
                this._policyName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.cloudformation.UserResource.PolicyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``UserResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public java.lang.Object getPolicyDocument() {
                return this.jsiiGet("policyDocument", java.lang.Object.class);
            }
            /**
             * ``UserResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public void setPolicyDocument(final com.fasterxml.jackson.databind.node.ObjectNode value) {
                this.jsiiSet("policyDocument", java.util.Objects.requireNonNull(value, "policyDocument is required"));
            }
            /**
             * ``UserResource.PolicyProperty.PolicyDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policydocument
             */
            public void setPolicyDocument(final software.amazon.awscdk.Token value) {
                this.jsiiSet("policyDocument", java.util.Objects.requireNonNull(value, "policyDocument is required"));
            }
            /**
             * ``UserResource.PolicyProperty.PolicyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            public java.lang.Object getPolicyName() {
                return this.jsiiGet("policyName", java.lang.Object.class);
            }
            /**
             * ``UserResource.PolicyProperty.PolicyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            public void setPolicyName(final java.lang.String value) {
                this.jsiiSet("policyName", java.util.Objects.requireNonNull(value, "policyName is required"));
            }
            /**
             * ``UserResource.PolicyProperty.PolicyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html#cfn-iam-policies-policyname
             */
            public void setPolicyName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("policyName", java.util.Objects.requireNonNull(value, "policyName is required"));
            }
        }
    }
}
