package software.amazon.awscdk.services.iam;

/**
 * The AWS::IAM::Policy resource associates an IAM policy with IAM users, roles,
 * or groups. For more information about IAM policies, see [Overview of IAM
 * Policies](http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
 * in the IAM User Guide guide.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:54:34.618Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Policy")
public class Policy extends software.amazon.awscdk.Construct implements software.amazon.awscdk.IDependable {
    protected Policy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Policy(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.iam.PolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Adds a statement to the policy document.
     */
    public void addStatement(final software.amazon.awscdk.PolicyStatement statement) {
        this.jsiiCall("addStatement", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Attaches this policy to a group.
     */
    public void attachToGroup(final software.amazon.awscdk.services.iam.Group group) {
        this.jsiiCall("attachToGroup", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(group, "group is required")).toArray());
    }

    /**
     * Attaches this policy to a role.
     */
    public void attachToRole(final software.amazon.awscdk.services.iam.Role role) {
        this.jsiiCall("attachToRole", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(role, "role is required")).toArray());
    }

    /**
     * Attaches this policy to a user.
     */
    public void attachToUser(final software.amazon.awscdk.services.iam.User user) {
        this.jsiiCall("attachToUser", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(user, "user is required")).toArray());
    }

    /**
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @Override
    public java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * Lists all the elements consumers should "depend-on".
     */
    @Override
    public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
        return this.jsiiGet("dependencyElements", java.util.List.class);
    }

    /**
     * The policy document.
     */
    public software.amazon.awscdk.PolicyDocument getDocument() {
        return this.jsiiGet("document", software.amazon.awscdk.PolicyDocument.class);
    }

    /**
     * The name of this policy.
     */
    public java.lang.String getPolicyName() {
        return this.jsiiGet("policyName", java.lang.String.class);
    }
}
