package software.amazon.awscdk.services.iam;

/**
 * IAM Role
 * 
 * Defines an IAM role. The role is created with an assume policy document associated with
 * the specified AWS service principal defined in `serviceAssumeRole`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:14:44.768Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Role")
public class Role extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.iam.IIdentityResource,software.amazon.awscdk.services.iam.IPrincipal,software.amazon.awscdk.IDependable {
    protected Role(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Role(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.iam.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Adds a permission to the role's default policy document.
     * If there is no default policy attached to this role, it will be created.
     */
    @Override
    public void addToPolicy(final software.amazon.awscdk.PolicyStatement statement) {
        this.jsiiCall("addToPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Attaches a policy to this role.
     * @param policy The policy to attach
     */
    @Override
    public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(policy, "policy is required")).toArray());
    }

    /**
     * Attaches a managed policy to this role.
     * @param arn The ARN of the managed policy to attach.
     */
    @Override
    public void attachManagedPolicy(final software.amazon.awscdk.Arn arn) {
        this.jsiiCall("attachManagedPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(arn, "arn is required")).toArray());
    }

    /**
     * Returns the role.
     */
    @Override
    public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
        return this.jsiiGet("dependencyElements", java.util.List.class);
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    public software.amazon.awscdk.PolicyPrincipal getPrincipal() {
        return this.jsiiGet("principal", software.amazon.awscdk.PolicyPrincipal.class);
    }

    /**
     * Returns the ARN of this role.
     */
    public software.amazon.awscdk.services.iam.RoleArn getRoleArn() {
        return this.jsiiGet("roleArn", software.amazon.awscdk.services.iam.RoleArn.class);
    }

    /**
     * Returns the name of the role.
     */
    public software.amazon.awscdk.services.iam.RoleName getRoleName() {
        return this.jsiiGet("roleName", software.amazon.awscdk.services.iam.RoleName.class);
    }

    /**
     * The assume role policy document associated with this role.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.PolicyDocument getAssumeRolePolicy() {
        return this.jsiiGet("assumeRolePolicy", software.amazon.awscdk.PolicyDocument.class);
    }
}
