package software.amazon.awscdk.services.iam;

/**
 * The AWS::IAM::Policy resource associates an IAM policy with IAM users, roles, or groups.
 * 
 * For more information about IAM policies, see [Overview of IAM
 * Policies](http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
 * in the IAM User Guide guide.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:07:15.492Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Policy")
public class Policy extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IPolicy {
    protected Policy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Policy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.iam.PolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Policy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IPolicy fromPolicyName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String policyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Policy.class, "fromPolicyName", software.amazon.awscdk.services.iam.IPolicy.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(policyName, "policyName is required") });
    }

    /**
     * Adds a statement to the policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        this.jsiiCall("addStatements", Void.class, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Attaches this policy to a group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToGroup(final software.amazon.awscdk.services.iam.IGroup group) {
        this.jsiiCall("attachToGroup", Void.class, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Attaches this policy to a role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToRole(final software.amazon.awscdk.services.iam.IRole role) {
        this.jsiiCall("attachToRole", Void.class, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Attaches this policy to a user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToUser(final software.amazon.awscdk.services.iam.IUser user) {
        this.jsiiCall("attachToUser", Void.class, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * The policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return this.jsiiGet("document", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }

    /**
     * The name of this policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getPolicyName() {
        return this.jsiiGet("policyName", java.lang.String.class);
    }
}
