package software.amazon.awscdk.services.iam;

/**
 * Interface for creating a policy statement.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:00:39.596Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyStatementProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * List of actions to add to the statement.
     * 
     * Default: - no actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getActions();
    /**
     * Conditions to add to the statement.
     * 
     * Default: - no condition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.Object> getConditions();
    /**
     * Whether to allow or deny the actions in this statement.
     * 
     * Default: - allow
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Effect getEffect();
    /**
     * List of principals to add to the statement.
     * 
     * Default: - no principals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals();
    /**
     * Resource ARNs to add to the statement.
     * 
     * Default: - no principals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getResources();

    /**
     * @return a {@link Builder} of {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _actions;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _conditions;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.Effect _effect;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IPrincipal> _principals;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _resources;

        /**
         * Sets the value of Actions
         * @param value List of actions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withActions(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._actions = value;
            return this;
        }
        /**
         * Sets the value of Conditions
         * @param value Conditions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withConditions(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._conditions = value;
            return this;
        }
        /**
         * Sets the value of Effect
         * @param value Whether to allow or deny the actions in this statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEffect(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Effect value) {
            this._effect = value;
            return this;
        }
        /**
         * Sets the value of Principals
         * @param value List of principals to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPrincipals(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> value) {
            this._principals = value;
            return this;
        }
        /**
         * Sets the value of Resources
         * @param value Resource ARNs to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withResources(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._resources = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyStatementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public PolicyStatementProps build() {
            return new PolicyStatementProps() {
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $actions = _actions;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $conditions = _conditions;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.Effect $effect = _effect;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> $principals = _principals;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $resources = _resources;

                @Override
                public java.util.List<java.lang.String> getActions() {
                    return this.$actions;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getConditions() {
                    return this.$conditions;
                }

                @Override
                public software.amazon.awscdk.services.iam.Effect getEffect() {
                    return this.$effect;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals() {
                    return this.$principals;
                }

                @Override
                public java.util.List<java.lang.String> getResources() {
                    return this.$resources;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getActions() != null) {
                        obj.set("actions", om.valueToTree(this.getActions()));
                    }
                    if (this.getConditions() != null) {
                        obj.set("conditions", om.valueToTree(this.getConditions()));
                    }
                    if (this.getEffect() != null) {
                        obj.set("effect", om.valueToTree(this.getEffect()));
                    }
                    if (this.getPrincipals() != null) {
                        obj.set("principals", om.valueToTree(this.getPrincipals()));
                    }
                    if (this.getResources() != null) {
                        obj.set("resources", om.valueToTree(this.getResources()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.PolicyStatementProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * List of actions to add to the statement.
         * 
         * Default: - no actions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getActions() {
            return this.jsiiGet("actions", java.util.List.class);
        }

        /**
         * Conditions to add to the statement.
         * 
         * Default: - no condition
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getConditions() {
            return this.jsiiGet("conditions", java.util.Map.class);
        }

        /**
         * Whether to allow or deny the actions in this statement.
         * 
         * Default: - allow
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Effect getEffect() {
            return this.jsiiGet("effect", software.amazon.awscdk.services.iam.Effect.class);
        }

        /**
         * List of principals to add to the statement.
         * 
         * Default: - no principals
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals() {
            return this.jsiiGet("principals", java.util.List.class);
        }

        /**
         * Resource ARNs to add to the statement.
         * 
         * Default: - no principals
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getResources() {
            return this.jsiiGet("resources", java.util.List.class);
        }
    }
}
