package software.amazon.awscdk.services.iam;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:00:39.599Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Groups to add this user to.
     * 
     * You can also use `addToGroup` to add this
     * user to a group.
     * 
     * Default: - No groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups();
    /**
     * A list managed policies associated with this role.
     * 
     * You can add managed policies later using `attachManagedPolicy(policy)`.
     * 
     * Default: - No managed policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies();
    /**
     * The password for the user. This is required so the user can access the AWS Management Console.
     * 
     * You can use `SecretValue.plainText` to specify a password in plain text or
     * use `secretsmanager.Secret.fromSecretAttributes` to reference a secret in
     * Secrets Manager.
     * 
     * Default: User won't be able to access the management console without a password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.SecretValue getPassword();
    /**
     * Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
     * 
     * If this is set to 'true', you must also specify "initialPassword".
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getPasswordResetRequired();
    /**
     * The path for the user name.
     * 
     * For more information about paths, see IAM
     * Identifiers in the IAM User Guide.
     * 
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();
    /**
     * A name for the IAM user.
     * 
     * For valid values, see the UserName parameter for
     * the CreateUser action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the user name.
     * 
     * If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * 
     * Default: Generated by CloudFormation (recommended)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getUserName();

    /**
     * @return a {@link Builder} of {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IGroup> _groups;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> _managedPolicies;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.SecretValue _password;
        @javax.annotation.Nullable
        private java.lang.Boolean _passwordResetRequired;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.String _userName;

        /**
         * Sets the value of Groups
         * @param value Groups to add this user to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IGroup> value) {
            this._groups = value;
            return this;
        }
        /**
         * Sets the value of ManagedPolicies
         * @param value A list managed policies associated with this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withManagedPolicies(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> value) {
            this._managedPolicies = value;
            return this;
        }
        /**
         * Sets the value of Password
         * @param value The password for the user. This is required so the user can access the AWS Management Console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPassword(@javax.annotation.Nullable final software.amazon.awscdk.core.SecretValue value) {
            this._password = value;
            return this;
        }
        /**
         * Sets the value of PasswordResetRequired
         * @param value Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPasswordResetRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._passwordResetRequired = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path for the user name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of UserName
         * @param value A name for the IAM user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withUserName(@javax.annotation.Nullable final java.lang.String value) {
            this._userName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public UserProps build() {
            return new UserProps() {
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IGroup> $groups = _groups;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> $managedPolicies = _managedPolicies;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.SecretValue $password = _password;
                @javax.annotation.Nullable
                private final java.lang.Boolean $passwordResetRequired = _passwordResetRequired;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;
                @javax.annotation.Nullable
                private final java.lang.String $userName = _userName;

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
                    return this.$groups;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
                    return this.$managedPolicies;
                }

                @Override
                public software.amazon.awscdk.core.SecretValue getPassword() {
                    return this.$password;
                }

                @Override
                public java.lang.Boolean getPasswordResetRequired() {
                    return this.$passwordResetRequired;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.lang.String getUserName() {
                    return this.$userName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getGroups() != null) {
                        obj.set("groups", om.valueToTree(this.getGroups()));
                    }
                    if (this.getManagedPolicies() != null) {
                        obj.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
                    }
                    if (this.getPassword() != null) {
                        obj.set("password", om.valueToTree(this.getPassword()));
                    }
                    if (this.getPasswordResetRequired() != null) {
                        obj.set("passwordResetRequired", om.valueToTree(this.getPasswordResetRequired()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree(this.getPath()));
                    }
                    if (this.getUserName() != null) {
                        obj.set("userName", om.valueToTree(this.getUserName()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.UserProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Groups to add this user to.
         * 
         * You can also use `addToGroup` to add this
         * user to a group.
         * 
         * Default: - No groups.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
            return this.jsiiGet("groups", java.util.List.class);
        }

        /**
         * A list managed policies associated with this role.
         * 
         * You can add managed policies later using `attachManagedPolicy(policy)`.
         * 
         * Default: - No managed policies.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
            return this.jsiiGet("managedPolicies", java.util.List.class);
        }

        /**
         * The password for the user. This is required so the user can access the AWS Management Console.
         * 
         * You can use `SecretValue.plainText` to specify a password in plain text or
         * use `secretsmanager.Secret.fromSecretAttributes` to reference a secret in
         * Secrets Manager.
         * 
         * Default: User won't be able to access the management console without a password.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.SecretValue getPassword() {
            return this.jsiiGet("password", software.amazon.awscdk.core.SecretValue.class);
        }

        /**
         * Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
         * 
         * If this is set to 'true', you must also specify "initialPassword".
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getPasswordResetRequired() {
            return this.jsiiGet("passwordResetRequired", java.lang.Boolean.class);
        }

        /**
         * The path for the user name.
         * 
         * For more information about paths, see IAM
         * Identifiers in the IAM User Guide.
         * 
         * Default: /
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * A name for the IAM user.
         * 
         * For valid values, see the UserName parameter for
         * the CreateUser action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the user name.
         * 
         * If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * 
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * 
         * Default: Generated by CloudFormation (recommended)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getUserName() {
            return this.jsiiGet("userName", java.lang.String.class);
        }
    }
}
