package software.amazon.awscdk.services.iam;

/**
 * Managed policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:26:07.967Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.ManagedPolicy")
public class ManagedPolicy extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IManagedPolicy {

    protected ManagedPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedPolicy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.ManagedPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props }));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedPolicy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") }));
    }

    /**
     * Construct a managed policy from one of the policies that AWS manages.
     * 
     * For this managed policy, you only need to know the name to be able to use it.
     * 
     * Some managed policy names start with "service-role/", some start with
     * "job-function/", and some don't start with anything. Do include the
     * prefix when constructing this object.
     * 
     * @param managedPolicyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IManagedPolicy fromAwsManagedPolicyName(final java.lang.String managedPolicyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ManagedPolicy.class, "fromAwsManagedPolicyName", software.amazon.awscdk.services.iam.IManagedPolicy.class, new Object[] { java.util.Objects.requireNonNull(managedPolicyName, "managedPolicyName is required") });
    }

    /**
     * Construct a customer managed policy from the managedPolicyName.
     * 
     * For this managed policy, you only need to know the name to be able to use it.
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param managedPolicyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IManagedPolicy fromManagedPolicyName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String managedPolicyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ManagedPolicy.class, "fromManagedPolicyName", software.amazon.awscdk.services.iam.IManagedPolicy.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(managedPolicyName, "managedPolicyName is required") });
    }

    /**
     * Adds a statement to the policy document.
     * 
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        this.jsiiCall("addStatements", Void.class, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Attaches this policy to a group.
     * 
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToGroup(final software.amazon.awscdk.services.iam.IGroup group) {
        this.jsiiCall("attachToGroup", Void.class, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Attaches this policy to a role.
     * 
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToRole(final software.amazon.awscdk.services.iam.IRole role) {
        this.jsiiCall("attachToRole", Void.class, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Attaches this policy to a user.
     * 
     * @param user This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToUser(final software.amazon.awscdk.services.iam.IUser user) {
        this.jsiiCall("attachToUser", Void.class, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * The description of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * The policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return this.jsiiGet("document", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }

    /**
     * Returns the ARN of this managed policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getManagedPolicyArn() {
        return this.jsiiGet("managedPolicyArn", java.lang.String.class);
    }

    /**
     * The name of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getManagedPolicyName() {
        return this.jsiiGet("managedPolicyName", java.lang.String.class);
    }

    /**
     * The path of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getPath() {
        return this.jsiiGet("path", java.lang.String.class);
    }
}
