package software.amazon.awscdk.services.iam;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:26:07.969Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group.
     * 
     * Default: - No groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups();

    /**
     * The name of the policy.
     * 
     * If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * 
     * Default: - Uses the logical ID of the policy resource, which is ensured
     * to be unique within the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPolicyName();

    /**
     * Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role.
     * 
     * Default: - No roles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles();

    /**
     * Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later.
     * 
     * Default: - No statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements();

    /**
     * Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user.
     * 
     * Default: - No users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers();

    /**
     * @return a {@link Builder} of {@link PolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private java.lang.String policyName;
        private java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        private java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Sets the value of Groups
         * @param groups Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(java.util.List<software.amazon.awscdk.services.iam.IGroup> groups) {
            this.groups = groups;
            return this;
        }

        /**
         * Sets the value of PolicyName
         * @param policyName The name of the policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of Roles
         * @param roles Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(java.util.List<software.amazon.awscdk.services.iam.IRole> roles) {
            this.roles = roles;
            return this;
        }

        /**
         * Sets the value of Statements
         * @param statements Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.statements = statements;
            return this;
        }

        /**
         * Sets the value of Users
         * @param users Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            this.users = users;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public PolicyProps build() {
            return new Jsii$Proxy(groups, policyName, roles, statements, users);
        }
    }

    /**
     * An implementation for {@link PolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyProps {
        private final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private final java.lang.String policyName;
        private final java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        private final java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.groups = this.jsiiGet("groups", java.util.List.class);
            this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            this.roles = this.jsiiGet("roles", java.util.List.class);
            this.statements = this.jsiiGet("statements", java.util.List.class);
            this.users = this.jsiiGet("users", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<software.amazon.awscdk.services.iam.IGroup> groups, java.lang.String policyName, java.util.List<software.amazon.awscdk.services.iam.IRole> roles, java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements, java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groups = groups;
            this.policyName = policyName;
            this.roles = roles;
            this.statements = statements;
            this.users = users;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
            return this.groups;
        }

        @Override
        public java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.roles;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.statements;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
            return this.users;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getGroups() != null) {
                obj.set("groups", om.valueToTree(this.getGroups()));
            }
            if (this.getPolicyName() != null) {
                obj.set("policyName", om.valueToTree(this.getPolicyName()));
            }
            if (this.getRoles() != null) {
                obj.set("roles", om.valueToTree(this.getRoles()));
            }
            if (this.getStatements() != null) {
                obj.set("statements", om.valueToTree(this.getStatements()));
            }
            if (this.getUsers() != null) {
                obj.set("users", om.valueToTree(this.getUsers()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyProps.Jsii$Proxy that = (PolicyProps.Jsii$Proxy) o;

            if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
            if (this.policyName != null ? !this.policyName.equals(that.policyName) : that.policyName != null) return false;
            if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
            if (this.statements != null ? !this.statements.equals(that.statements) : that.statements != null) return false;
            return this.users != null ? this.users.equals(that.users) : that.users == null;
        }

        @Override
        public int hashCode() {
            int result = this.groups != null ? this.groups.hashCode() : 0;
            result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
            result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
            return result;
        }
    }
}
