/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.LazyRoleProps;
import software.amazon.awscdk.services.iam.Policy;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.PrincipalPolicyFragment;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-iam.LazyRole")
public class LazyRole
extends Resource
implements IRole {
    protected LazyRole(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LazyRole(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LazyRole(@NotNull Construct scope, @NotNull String id, @NotNull LazyRoleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void addManagedPolicy(@NotNull IManagedPolicy policy) {
        Kernel.call((Object)this, (String)"addManagedPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    @NotNull
    public Boolean addToPolicy(@NotNull PolicyStatement statement) {
        return (Boolean)Kernel.call((Object)this, (String)"addToPolicy", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public AddToPrincipalPolicyResult addToPrincipalPolicy(@NotNull PolicyStatement statement) {
        return (AddToPrincipalPolicyResult)Kernel.call((Object)this, (String)"addToPrincipalPolicy", (NativeType)NativeType.forClass(AddToPrincipalPolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    public void attachInlinePolicy(@NotNull Policy policy) {
        Kernel.call((Object)this, (String)"attachInlinePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IPrincipal identity, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(identity, "identity is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantPassRole(@NotNull IPrincipal identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPassRole", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public String getAssumeRoleAction() {
        return (String)Kernel.get((Object)this, (String)"assumeRoleAction", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @Override
    @NotNull
    public PrincipalPolicyFragment getPolicyFragment() {
        return (PrincipalPolicyFragment)((Object)Kernel.get((Object)this, (String)"policyFragment", (NativeType)NativeType.forClass(PrincipalPolicyFragment.class)));
    }

    @Override
    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getRoleId() {
        return (String)Kernel.get((Object)this, (String)"roleId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRoleName() {
        return (String)Kernel.get((Object)this, (String)"roleName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getPrincipalAccount() {
        return (String)Kernel.get((Object)this, (String)"principalAccount", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LazyRole> {
        private final Construct scope;
        private final String id;
        private final LazyRoleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LazyRoleProps.Builder();
        }

        public Builder assumedBy(IPrincipal assumedBy) {
            this.props.assumedBy(assumedBy);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        @Deprecated
        public Builder externalId(String externalId) {
            this.props.externalId(externalId);
            return this;
        }

        public Builder externalIds(List<String> externalIds) {
            this.props.externalIds(externalIds);
            return this;
        }

        public Builder inlinePolicies(Map<String, ? extends PolicyDocument> inlinePolicies) {
            this.props.inlinePolicies(inlinePolicies);
            return this;
        }

        public Builder managedPolicies(List<? extends IManagedPolicy> managedPolicies) {
            this.props.managedPolicies(managedPolicies);
            return this;
        }

        public Builder maxSessionDuration(Duration maxSessionDuration) {
            this.props.maxSessionDuration(maxSessionDuration);
            return this;
        }

        public Builder path(String path) {
            this.props.path(path);
            return this;
        }

        public Builder permissionsBoundary(IManagedPolicy permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder roleName(String roleName) {
            this.props.roleName(roleName);
            return this;
        }

        public LazyRole build() {
            return new LazyRole(this.scope, this.id, this.props.build());
        }
    }
}

