package software.amazon.awscdk.services.iam;

/**
 * Properties for defining an IAM Role.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-10T21:37:39.344Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.RoleProps")
@software.amazon.jsii.Jsii.Proxy(RoleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RoleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`) which can assume this role.
     * <p>
     * You can later modify the assume role policy document by accessing it via
     * the <code>assumeRolePolicy</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getAssumedBy();

    /**
     * A description of the role.
     * <p>
     * It can be up to 1000 characters long.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (deprecated) ID that the role assumer needs to provide when assuming this role.
     * <p>
     * If the configured and provided external IDs do not match, the
     * AssumeRole operation will fail.
     * <p>
     * Default: No external ID required
     * <p>
     * @deprecated see {@link externalIds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
        return null;
    }

    /**
     * List of IDs that the role assumer needs to provide one of when assuming this role.
     * <p>
     * If the configured and provided external IDs do not match, the
     * AssumeRole operation will fail.
     * <p>
     * Default: No external ID required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExternalIds() {
        return null;
    }

    /**
     * A list of named policies to inline into this role.
     * <p>
     * These policies will be
     * created with the role, whereas those added by <code>addToPolicy</code> are added
     * using a separate CloudFormation resource (allowing a way around circular
     * dependencies that could otherwise be introduced).
     * <p>
     * Default: - No policy is inlined in the Role resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> getInlinePolicies() {
        return null;
    }

    /**
     * A list of managed policies associated with this role.
     * <p>
     * You can add managed policies later using
     * <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
     * <p>
     * Default: - No managed policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
        return null;
    }

    /**
     * The maximum session duration that you want to set for the specified role.
     * <p>
     * This setting can have a value from 1 hour (3600sec) to 12 (43200sec) hours.
     * <p>
     * Anyone who assumes the role from the AWS CLI or API can use the
     * DurationSeconds API parameter or the duration-seconds CLI parameter to
     * request a longer session. The MaxSessionDuration setting determines the
     * maximum duration that can be requested using the DurationSeconds
     * parameter.
     * <p>
     * If users don't specify a value for the DurationSeconds parameter, their
     * security credentials are valid for one hour by default. This applies when
     * you use the AssumeRole* API operations or the assume-role* CLI operations
     * but does not apply when you use those operations to create a console URL.
     * <p>
     * Default: Duration.hours(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxSessionDuration() {
        return null;
    }

    /**
     * The path associated with this role.
     * <p>
     * For information about IAM paths, see
     * Friendly Names and Paths in IAM User Guide.
     * <p>
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * AWS supports permissions boundaries for IAM entities (users or roles).
     * <p>
     * A permissions boundary is an advanced feature for using a managed policy
     * to set the maximum permissions that an identity-based policy can grant to
     * an IAM entity. An entity's permissions boundary allows it to perform only
     * the actions that are allowed by both its identity-based policies and its
     * permissions boundaries.
     * <p>
     * Default: - No permissions boundary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
        return null;
    }

    /**
     * A name for the IAM role.
     * <p>
     * For valid values, see the RoleName parameter for
     * the CreateRole action in the IAM API Reference.
     * <p>
     * IMPORTANT: If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * <p>
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that ID
     * for the role name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RoleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RoleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RoleProps> {
        private software.amazon.awscdk.services.iam.IPrincipal assumedBy;
        private java.lang.String description;
        private java.lang.String externalId;
        private java.util.List<java.lang.String> externalIds;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies;
        private java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        private software.amazon.awscdk.core.Duration maxSessionDuration;
        private java.lang.String path;
        private software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary;
        private java.lang.String roleName;

        /**
         * Sets the value of {@link RoleProps#getAssumedBy}
         * @param assumedBy The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`) which can assume this role. This parameter is required.
         *                  You can later modify the assume role policy document by accessing it via
         *                  the <code>assumeRolePolicy</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumedBy(software.amazon.awscdk.services.iam.IPrincipal assumedBy) {
            this.assumedBy = assumedBy;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getDescription}
         * @param description A description of the role.
         *                    It can be up to 1000 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getExternalId}
         * @param externalId ID that the role assumer needs to provide when assuming this role.
         *                   If the configured and provided external IDs do not match, the
         *                   AssumeRole operation will fail.
         * @return {@code this}
         * @deprecated see {@link externalIds}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder externalId(java.lang.String externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getExternalIds}
         * @param externalIds List of IDs that the role assumer needs to provide one of when assuming this role.
         *                    If the configured and provided external IDs do not match, the
         *                    AssumeRole operation will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalIds(java.util.List<java.lang.String> externalIds) {
            this.externalIds = externalIds;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getInlinePolicies}
         * @param inlinePolicies A list of named policies to inline into this role.
         *                       These policies will be
         *                       created with the role, whereas those added by <code>addToPolicy</code> are added
         *                       using a separate CloudFormation resource (allowing a way around circular
         *                       dependencies that could otherwise be introduced).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inlinePolicies(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies) {
            this.inlinePolicies = (java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument>)inlinePolicies;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getManagedPolicies}
         * @param managedPolicies A list of managed policies associated with this role.
         *                        You can add managed policies later using
         *                        <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder managedPolicies(java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.managedPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)managedPolicies;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getMaxSessionDuration}
         * @param maxSessionDuration The maximum session duration that you want to set for the specified role.
         *                           This setting can have a value from 1 hour (3600sec) to 12 (43200sec) hours.
         *                           <p>
         *                           Anyone who assumes the role from the AWS CLI or API can use the
         *                           DurationSeconds API parameter or the duration-seconds CLI parameter to
         *                           request a longer session. The MaxSessionDuration setting determines the
         *                           maximum duration that can be requested using the DurationSeconds
         *                           parameter.
         *                           <p>
         *                           If users don't specify a value for the DurationSeconds parameter, their
         *                           security credentials are valid for one hour by default. This applies when
         *                           you use the AssumeRole* API operations or the assume-role* CLI operations
         *                           but does not apply when you use those operations to create a console URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSessionDuration(software.amazon.awscdk.core.Duration maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getPath}
         * @param path The path associated with this role.
         *             For information about IAM paths, see
         *             Friendly Names and Paths in IAM User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getPermissionsBoundary}
         * @param permissionsBoundary AWS supports permissions boundaries for IAM entities (users or roles).
         *                            A permissions boundary is an advanced feature for using a managed policy
         *                            to set the maximum permissions that an identity-based policy can grant to
         *                            an IAM entity. An entity's permissions boundary allows it to perform only
         *                            the actions that are allowed by both its identity-based policies and its
         *                            permissions boundaries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        /**
         * Sets the value of {@link RoleProps#getRoleName}
         * @param roleName A name for the IAM role.
         *                 For valid values, see the RoleName parameter for
         *                 the CreateRole action in the IAM API Reference.
         *                 <p>
         *                 IMPORTANT: If you specify a name, you cannot perform updates that require
         *                 replacement of this resource. You can perform updates that require no or
         *                 some interruption. If you must replace the resource, specify a new name.
         *                 <p>
         *                 If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         *                 acknowledge your template's capabilities. For more information, see
         *                 Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleName(java.lang.String roleName) {
            this.roleName = roleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RoleProps build() {
            return new Jsii$Proxy(assumedBy, description, externalId, externalIds, inlinePolicies, managedPolicies, maxSessionDuration, path, permissionsBoundary, roleName);
        }
    }

    /**
     * An implementation for {@link RoleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoleProps {
        private final software.amazon.awscdk.services.iam.IPrincipal assumedBy;
        private final java.lang.String description;
        private final java.lang.String externalId;
        private final java.util.List<java.lang.String> externalIds;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies;
        private final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        private final software.amazon.awscdk.core.Duration maxSessionDuration;
        private final java.lang.String path;
        private final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary;
        private final java.lang.String roleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assumedBy = software.amazon.jsii.Kernel.get(this, "assumedBy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externalIds = software.amazon.jsii.Kernel.get(this, "externalIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.inlinePolicies = software.amazon.jsii.Kernel.get(this, "inlinePolicies", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class)));
            this.managedPolicies = software.amazon.jsii.Kernel.get(this, "managedPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class)));
            this.maxSessionDuration = software.amazon.jsii.Kernel.get(this, "maxSessionDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissionsBoundary = software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class));
            this.roleName = software.amazon.jsii.Kernel.get(this, "roleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.iam.IPrincipal assumedBy, final java.lang.String description, final java.lang.String externalId, final java.util.List<java.lang.String> externalIds, final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies, final java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies, final software.amazon.awscdk.core.Duration maxSessionDuration, final java.lang.String path, final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary, final java.lang.String roleName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assumedBy = java.util.Objects.requireNonNull(assumedBy, "assumedBy is required");
            this.description = description;
            this.externalId = externalId;
            this.externalIds = externalIds;
            this.inlinePolicies = (java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument>)inlinePolicies;
            this.managedPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)managedPolicies;
            this.maxSessionDuration = maxSessionDuration;
            this.path = path;
            this.permissionsBoundary = permissionsBoundary;
            this.roleName = roleName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IPrincipal getAssumedBy() {
            return this.assumedBy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExternalId() {
            return this.externalId;
        }

        @Override
        public final java.util.List<java.lang.String> getExternalIds() {
            return this.externalIds;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> getInlinePolicies() {
            return this.inlinePolicies;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
            return this.managedPolicies;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxSessionDuration() {
            return this.maxSessionDuration;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        @Override
        public final java.lang.String getRoleName() {
            return this.roleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assumedBy", om.valueToTree(this.getAssumedBy()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExternalId() != null) {
                data.set("externalId", om.valueToTree(this.getExternalId()));
            }
            if (this.getExternalIds() != null) {
                data.set("externalIds", om.valueToTree(this.getExternalIds()));
            }
            if (this.getInlinePolicies() != null) {
                data.set("inlinePolicies", om.valueToTree(this.getInlinePolicies()));
            }
            if (this.getManagedPolicies() != null) {
                data.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
            }
            if (this.getMaxSessionDuration() != null) {
                data.set("maxSessionDuration", om.valueToTree(this.getMaxSessionDuration()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPermissionsBoundary() != null) {
                data.set("permissionsBoundary", om.valueToTree(this.getPermissionsBoundary()));
            }
            if (this.getRoleName() != null) {
                data.set("roleName", om.valueToTree(this.getRoleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.RoleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RoleProps.Jsii$Proxy that = (RoleProps.Jsii$Proxy) o;

            if (!assumedBy.equals(that.assumedBy)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
            if (this.externalIds != null ? !this.externalIds.equals(that.externalIds) : that.externalIds != null) return false;
            if (this.inlinePolicies != null ? !this.inlinePolicies.equals(that.inlinePolicies) : that.inlinePolicies != null) return false;
            if (this.managedPolicies != null ? !this.managedPolicies.equals(that.managedPolicies) : that.managedPolicies != null) return false;
            if (this.maxSessionDuration != null ? !this.maxSessionDuration.equals(that.maxSessionDuration) : that.maxSessionDuration != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.permissionsBoundary != null ? !this.permissionsBoundary.equals(that.permissionsBoundary) : that.permissionsBoundary != null) return false;
            return this.roleName != null ? this.roleName.equals(that.roleName) : that.roleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assumedBy.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
            result = 31 * result + (this.externalIds != null ? this.externalIds.hashCode() : 0);
            result = 31 * result + (this.inlinePolicies != null ? this.inlinePolicies.hashCode() : 0);
            result = 31 * result + (this.managedPolicies != null ? this.managedPolicies.hashCode() : 0);
            result = 31 * result + (this.maxSessionDuration != null ? this.maxSessionDuration.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.permissionsBoundary != null ? this.permissionsBoundary.hashCode() : 0);
            result = 31 * result + (this.roleName != null ? this.roleName.hashCode() : 0);
            return result;
        }
    }
}
