package software.amazon.awscdk.services.iam;

/**
 * Specify a principal by the Amazon Resource Name (ARN).
 * <p>
 * You can specify AWS accounts, IAM users, Federated SAML users, IAM roles, and specific assumed-role sessions.
 * You cannot specify IAM groups or instance profiles as principals
 * <p>
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:39:41.784Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.ArnPrincipal")
public class ArnPrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected ArnPrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ArnPrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param arn Amazon Resource Name (ARN) of the principal entity (i.e. arn:aws:iam::123456789012:user/user-name). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ArnPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Resource Name (ARN) of the principal entity (i.e. arn:aws:iam::123456789012:user/user-name).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }
}
