package software.amazon.awscdk.services.iam;

/**
 * Properties for a SAML provider.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.35.0 (build 6ebef96)", date = "2021-10-05T13:28:38.500Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.SamlProviderProps")
@software.amazon.jsii.Jsii.Proxy(SamlProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SamlProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.SamlMetadataDocument getMetadataDocument();

    /**
     * The name of the provider to create.
     * <p>
     * This parameter allows a string of characters consisting of upper and
     * lowercase alphanumeric characters with no spaces. You can also include
     * any of the following characters: _+=,.&#64;-
     * <p>
     * Length must be between 1 and 128 characters.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SamlProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SamlProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SamlProviderProps> {
        private software.amazon.awscdk.services.iam.SamlMetadataDocument metadataDocument;
        private java.lang.String name;

        /**
         * Sets the value of {@link SamlProviderProps#getMetadataDocument}
         * @param metadataDocument An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataDocument(software.amazon.awscdk.services.iam.SamlMetadataDocument metadataDocument) {
            this.metadataDocument = metadataDocument;
            return this;
        }

        /**
         * Sets the value of {@link SamlProviderProps#getName}
         * @param name The name of the provider to create.
         *             This parameter allows a string of characters consisting of upper and
         *             lowercase alphanumeric characters with no spaces. You can also include
         *             any of the following characters: _+=,.&#64;-
         *             <p>
         *             Length must be between 1 and 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SamlProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SamlProviderProps build() {
            return new Jsii$Proxy(metadataDocument, name);
        }
    }

    /**
     * An implementation for {@link SamlProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SamlProviderProps {
        private final software.amazon.awscdk.services.iam.SamlMetadataDocument metadataDocument;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metadataDocument = software.amazon.jsii.Kernel.get(this, "metadataDocument", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.SamlMetadataDocument.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.iam.SamlMetadataDocument metadataDocument, final java.lang.String name) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metadataDocument = java.util.Objects.requireNonNull(metadataDocument, "metadataDocument is required");
            this.name = name;
        }

        @Override
        public final software.amazon.awscdk.services.iam.SamlMetadataDocument getMetadataDocument() {
            return this.metadataDocument;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metadataDocument", om.valueToTree(this.getMetadataDocument()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.SamlProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SamlProviderProps.Jsii$Proxy that = (SamlProviderProps.Jsii$Proxy) o;

            if (!metadataDocument.equals(that.metadataDocument)) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metadataDocument.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
