/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.iam.IGroup;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.IUser;
import software.amazon.awscdk.services.iam.ManagedPolicyProps;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-iam.ManagedPolicy")
public class ManagedPolicy
extends Resource
implements IManagedPolicy {
    protected ManagedPolicy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedPolicy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ManagedPolicy(Construct scope, String id, ManagedPolicyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props}));
    }

    public ManagedPolicy(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")}));
    }

    public static IManagedPolicy fromAwsManagedPolicyName(String managedPolicyName) {
        return (IManagedPolicy)JsiiObject.jsiiStaticCall(ManagedPolicy.class, (String)"fromAwsManagedPolicyName", IManagedPolicy.class, (Object[])new Object[]{Objects.requireNonNull(managedPolicyName, "managedPolicyName is required")});
    }

    public static IManagedPolicy fromManagedPolicyName(Construct scope, String id, String managedPolicyName) {
        return (IManagedPolicy)JsiiObject.jsiiStaticCall(ManagedPolicy.class, (String)"fromManagedPolicyName", IManagedPolicy.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(managedPolicyName, "managedPolicyName is required")});
    }

    public void addStatements(PolicyStatement ... statement) {
        this.jsiiCall("addStatements", Void.class, Arrays.stream(statement).toArray(Object[]::new));
    }

    public void attachToGroup(IGroup group) {
        this.jsiiCall("attachToGroup", Void.class, new Object[]{Objects.requireNonNull(group, "group is required")});
    }

    public void attachToRole(IRole role) {
        this.jsiiCall("attachToRole", Void.class, new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    public void attachToUser(IUser user) {
        this.jsiiCall("attachToUser", Void.class, new Object[]{Objects.requireNonNull(user, "user is required")});
    }

    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", List.class, new Object[0]));
    }

    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public PolicyDocument getDocument() {
        return (PolicyDocument)((Object)this.jsiiGet("document", PolicyDocument.class));
    }

    @Override
    public String getManagedPolicyArn() {
        return (String)this.jsiiGet("managedPolicyArn", String.class);
    }

    public String getManagedPolicyName() {
        return (String)this.jsiiGet("managedPolicyName", String.class);
    }

    public String getPath() {
        return (String)this.jsiiGet("path", String.class);
    }
}

