/**
 * <h1>AWS Identity and Access Management Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define a role and add permissions to it. This will automatically create and
 * attach an IAM policy to the role:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Role role = Role.Builder.create(this, "MyRole")
 *         .assumedBy(new ServicePrincipal("sns.amazonaws.com"))
 *         .build();
 * 
 * role.addToPolicy(PolicyStatement.Builder.create()
 *         .resources(List.of("*"))
 *         .actions(List.of("lambda:InvokeFunction"))
 *         .build());
 * </pre></blockquote>
 * <p>
 * Define a policy and attach it to groups, users and roles. Note that it is possible to attach
 * the policy either by calling <code>xxx.attachInlinePolicy(policy)</code> or <code>policy.attachToXxx(xxx)</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * User user = User.Builder.create(this, "MyUser").password(cdk.SecretValue.plainText("1234")).build();
 * Group group = new Group(this, "MyGroup");
 * 
 * Policy policy = new Policy(this, "MyPolicy");
 * policy.attachToUser(user);
 * group.attachInlinePolicy(policy);
 * </pre></blockquote>
 * <p>
 * Managed policies can be attached using <code>xxx.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Group group = new Group(this, "MyGroup");
 * group.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("AdministratorAccess"));
 * </pre></blockquote>
 * <p>
 * <h2>Granting permissions to resources</h2>
 * <p>
 * Many of the AWS CDK resources have <code>grant*</code> methods that allow you to grant other resources access to that resource. As an example, the following code gives a Lambda function write permissions (Put, Update, Delete) to a DynamoDB table.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Function fn;
 * Table table;
 * 
 * 
 * table.grantWriteData(fn);
 * </pre></blockquote>
 * <p>
 * The more generic <code>grant</code> method allows you to give specific permissions to a resource:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Function fn;
 * Table table;
 * 
 * 
 * table.grant(fn, "dynamodb:PutItem");
 * </pre></blockquote>
 * <p>
 * The <code>grant*</code> methods accept an <code>IGrantable</code> object. This interface is implemented by IAM principlal resources (groups, users and roles) and resources that assume a role such as a Lambda function, EC2 instance or a Codebuild project.
 * <p>
 * You can find which <code>grant*</code> methods exist for a resource in the <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-construct-library.html">AWS CDK API Reference</a>.
 * <p>
 * <h2>Roles</h2>
 * <p>
 * Many AWS resources require <em>Roles</em> to operate. These Roles define the AWS API
 * calls an instance or other AWS service is allowed to make.
 * <p>
 * Creating Roles and populating them with the right permissions <em>Statements</em> is
 * a necessary but tedious part of setting up AWS infrastructure. In order to
 * help you focus on your business logic, CDK will take care of creating
 * roles and populating them with least-privilege permissions automatically.
 * <p>
 * All constructs that require Roles will create one for you if don't specify
 * one at construction time. Permissions will be added to that role
 * automatically if you associate the construct with other constructs from the
 * AWS Construct Library (for example, if you tell an <em>AWS CodePipeline</em> to trigger
 * an <em>AWS Lambda Function</em>, the Pipeline's Role will automatically get
 * <code>lambda:InvokeFunction</code> permissions on that particular Lambda Function),
 * or if you explicitly grant permissions using <code>grant</code> functions (see the
 * previous section).
 * <p>
 * <h3>Opting out of automatic permissions management</h3>
 * <p>
 * You may prefer to manage a Role's permissions yourself instead of having the
 * CDK automatically manage them for you. This may happen in one of the
 * following cases:
 * <p>
 * <ul>
 * <li>You don't like the permissions that CDK automatically generates and
 * want to substitute your own set.</li>
 * <li>The least-permissions policy that the CDK generates is becoming too
 * big for IAM to store, and you need to add some wildcards to keep the
 * policy size down.</li>
 * </ul>
 * <p>
 * To prevent constructs from updating your Role's policy, pass the object
 * returned by <code>myRole.withoutPolicyUpdates()</code> instead of <code>myRole</code> itself.
 * <p>
 * For example, to have an AWS CodePipeline <em>not</em> automatically add the required
 * permissions to trigger the expected targets, do the following:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Role role = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("codepipeline.amazonaws.com"))
 *         // custom description if desired
 *         .description("This is a custom role...")
 *         .build();
 * 
 * Pipeline.Builder.create(this, "Pipeline")
 *         // Give the Pipeline an immutable view of the Role
 *         .role(role.withoutPolicyUpdates())
 *         .build();
 * 
 * // You now have to manage the Role policies yourself
 * role.addToPolicy(PolicyStatement.Builder.create()
 *         .actions(List.of())
 *         .resources(List.of())
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Using existing roles</h3>
 * <p>
 * If there are Roles in your account that have already been created which you
 * would like to use in your CDK application, you can use <code>Role.fromRoleArn</code> to
 * import them, as follows:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IRole role = iam.Role.fromRoleArn(this, "Role", "arn:aws:iam::123456789012:role/MyExistingRole", FromRoleArnOptions.builder()
 *         // Set 'mutable' to 'false' to use the role as-is and prevent adding new
 *         // policies to it. The default is 'true', which means the role may be
 *         // modified as part of the deployment.
 *         .mutable(false)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h2>Configuring an ExternalId</h2>
 * <p>
 * If you need to create Roles that will be assumed by third parties, it is generally a good idea to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">require an <code>ExternalId</code>
 * to assume them</a>.  Configuring
 * an <code>ExternalId</code> works like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Role role = Role.Builder.create(this, "MyRole")
 *         .assumedBy(new AccountPrincipal("123456789012"))
 *         .externalIds(List.of("SUPPLY-ME"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Principals vs Identities</h2>
 * <p>
 * When we say <em>Principal</em>, we mean an entity you grant permissions to. This
 * entity can be an AWS Service, a Role, or something more abstract such as "all
 * users in this account" or even "all users in this organization". An
 * <em>Identity</em> is an IAM representing a single IAM entity that can have
 * a policy attached, one of <code>Role</code>, <code>User</code>, or <code>Group</code>.
 * <p>
 * <h2>IAM Principals</h2>
 * <p>
 * When defining policy statements as part of an AssumeRole policy or as part of a
 * resource policy, statements would usually refer to a specific IAM principal
 * under <code>Principal</code>.
 * <p>
 * IAM principals are modeled as classes that derive from the <code>iam.PolicyPrincipal</code>
 * abstract class. Principal objects include principal type (string) and value
 * (array of string), optional set of conditions and the action that this principal
 * requires when it is used in an assume role policy document.
 * <p>
 * To add a principal to a policy statement you can either use the abstract
 * <code>statement.addPrincipal</code>, one of the concrete <code>addXxxPrincipal</code> methods:
 * <p>
 * <ul>
 * <li><code>addAwsPrincipal</code>, <code>addArnPrincipal</code> or <code>new ArnPrincipal(arn)</code> for <code>{ "AWS": arn }</code></li>
 * <li><code>addAwsAccountPrincipal</code> or <code>new AccountPrincipal(accountId)</code> for <code>{ "AWS": account-arn }</code></li>
 * <li><code>addServicePrincipal</code> or <code>new ServicePrincipal(service)</code> for <code>{ "Service": service }</code></li>
 * <li><code>addAccountRootPrincipal</code> or <code>new AccountRootPrincipal()</code> for <code>{ "AWS": { "Ref: "AWS::AccountId" } }</code></li>
 * <li><code>addCanonicalUserPrincipal</code> or <code>new CanonicalUserPrincipal(id)</code> for <code>{ "CanonicalUser": id }</code></li>
 * <li><code>addFederatedPrincipal</code> or <code>new FederatedPrincipal(federated, conditions, assumeAction)</code> for
 * <code>{ "Federated": arn }</code> and a set of optional conditions and the assume role action to use.</li>
 * <li><code>addAnyPrincipal</code> or <code>new AnyPrincipal</code> for <code>{ "AWS": "*" }</code></li>
 * </ul>
 * <p>
 * If multiple principals are added to the policy statement, they will be merged together:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * PolicyStatement statement = new PolicyStatement();
 * statement.addServicePrincipal("cloudwatch.amazonaws.com");
 * statement.addServicePrincipal("ec2.amazonaws.com");
 * statement.addArnPrincipal("arn:aws:boom:boom");
 * </pre></blockquote>
 * <p>
 * Will result in:
 * <p>
 * <blockquote><pre>
 * {
 *   "Principal": {
 *     "Service": [ "cloudwatch.amazonaws.com", "ec2.amazonaws.com" ],
 *     "AWS": "arn:aws:boom:boom"
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * The <code>CompositePrincipal</code> class can also be used to define complex principals, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Role role = Role.Builder.create(this, "MyRole")
 *         .assumedBy(new CompositePrincipal(
 *         new ServicePrincipal("ec2.amazonaws.com"),
 *         new AccountPrincipal("1818188181818187272")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The <code>PrincipalWithConditions</code> class can be used to add conditions to a
 * principal, especially those that don't take a <code>conditions</code> parameter in their
 * constructor. The <code>principal.withConditions()</code> method can be used to create a
 * <code>PrincipalWithConditions</code> from an existing principal, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IPrincipal principal = new iam.AccountPrincipal('123456789000').withConditions(Map.of("StringEquals", Map.of("foo", "baz")));
 * </pre></blockquote>
 * <p>
 * <blockquote>
 * <p>
 * NOTE: If you need to define an IAM condition that uses a token (such as a
 * deploy-time attribute of another resource) in a JSON map key, use <code>CfnJson</code> to
 * render this condition. See <a href="./test/integ-condition-with-ref.ts">this test</a> for
 * an example.
 * <p>
 * </blockquote>
 * <p>
 * The <code>WebIdentityPrincipal</code> class can be used as a principal for web identities like
 * Cognito, Amazon, Google or Facebook, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IPrincipal principal = new iam.WebIdentityPrincipal('cognito-identity.amazonaws.com').withConditions(Map.of(
 *         "StringEquals", Map.of("cognito-identity.amazonaws.com:aud", "us-east-2:12345678-abcd-abcd-abcd-123456"),
 *         "ForAnyValue:StringLike", Map.of("cognito-identity.amazonaws.com:amr", "unauthenticated")));
 * </pre></blockquote>
 * <p>
 * <h2>Parsing JSON Policy Documents</h2>
 * <p>
 * The <code>PolicyDocument.fromJson</code> and <code>PolicyStatement.fromJson</code> static methods can be used to parse JSON objects. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Map&lt;String, Object&gt; policyDocument = Map.of(
 *         "Version", "2012-10-17",
 *         "Statement", List.of(Map.of(
 *                 "Sid", "FirstStatement",
 *                 "Effect", "Allow",
 *                 "Action", List.of("iam:ChangePassword"),
 *                 "Resource", "*"), Map.of(
 *                 "Sid", "SecondStatement",
 *                 "Effect", "Allow",
 *                 "Action", "s3:ListAllMyBuckets",
 *                 "Resource", "*"), Map.of(
 *                 "Sid", "ThirdStatement",
 *                 "Effect", "Allow",
 *                 "Action", List.of("s3:List*", "s3:Get*"),
 *                 "Resource", List.of("arn:aws:s3:::confidential-data", "arn:aws:s3:::confidential-data/*"),
 *                 "Condition", Map.of("Bool", Map.of("aws:MultiFactorAuthPresent", "true")))));
 * 
 * PolicyDocument customPolicyDocument = iam.PolicyDocument.fromJson(policyDocument);
 * 
 * // You can pass this document as an initial document to a ManagedPolicy
 * // or inline Policy.
 * ManagedPolicy newManagedPolicy = ManagedPolicy.Builder.create(this, "MyNewManagedPolicy")
 *         .document(customPolicyDocument)
 *         .build();
 * Policy newPolicy = Policy.Builder.create(this, "MyNewPolicy")
 *         .document(customPolicyDocument)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Permissions Boundaries</h2>
 * <p>
 * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
 * Boundaries</a>
 * can be used as a mechanism to prevent privilege esclation by creating new
 * <code>Role</code>s. Permissions Boundaries are a Managed Policy, attached to Roles or
 * Users, that represent the <em>maximum</em> set of permissions they can have. The
 * effective set of permissions of a Role (or User) will be the intersection of
 * the Identity Policy and the Permissions Boundary attached to the Role (or
 * User). Permissions Boundaries are typically created by account
 * Administrators, and their use on newly created <code>Role</code>s will be enforced by
 * IAM policies.
 * <p>
 * It is possible to attach Permissions Boundaries to all Roles created in a construct
 * tree all at once:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // Directly apply the boundary to a Role you create
 * Role role;
 * 
 * // Apply the boundary to an Role that was implicitly created for you
 * Function fn;
 * 
 * // Remove a Permissions Boundary that is inherited, for example from the Stack level
 * CustomResource customResource;
 * // This imports an existing policy.
 * IManagedPolicy boundary = iam.ManagedPolicy.fromManagedPolicyArn(this, "Boundary", "arn:aws:iam::123456789012:policy/boundary");
 * 
 * // This creates a new boundary
 * ManagedPolicy boundary2 = ManagedPolicy.Builder.create(this, "Boundary2")
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .effect(iam.Effect.DENY)
 *                     .actions(List.of("iam:*"))
 *                     .resources(List.of("*"))
 *                     .build()))
 *         .build();
 * iam.PermissionsBoundary.of(role).apply(boundary);
 * iam.PermissionsBoundary.of(fn).apply(boundary);
 * 
 * // Apply the boundary to all Roles in a stack
 * iam.PermissionsBoundary.of(this).apply(boundary);
 * iam.PermissionsBoundary.of(customResource).clear();
 * </pre></blockquote>
 * <p>
 * <h2>OpenID Connect Providers</h2>
 * <p>
 * OIDC identity providers are entities in IAM that describe an external identity
 * provider (IdP) service that supports the <a href="http://openid.net/connect">OpenID Connect</a> (OIDC) standard, such
 * as Google or Salesforce. You use an IAM OIDC identity provider when you want to
 * establish trust between an OIDC-compatible IdP and your AWS account. This is
 * useful when creating a mobile app or web application that requires access to AWS
 * resources, but you don't want to create custom sign-in code or manage your own
 * user identities. For more information about this scenario, see [About Web
 * Identity Federation] and the relevant documentation in the [Amazon Cognito
 * Identity Pools Developer Guide].
 * <p>
 * The following examples defines an OpenID Connect provider. Two client IDs
 * (audiences) are will be able to send authentication requests to
 * https://openid/connect.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * OpenIdConnectProvider provider = OpenIdConnectProvider.Builder.create(this, "MyProvider")
 *         .url("https://openid/connect")
 *         .clientIds(List.of("myclient1", "myclient2"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can specify an optional list of <code>thumbprints</code>. If not specified, the
 * thumbprint of the root certificate authority (CA) will automatically be obtained
 * from the host as described
 * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html">here</a>.
 * <p>
 * Once you define an OpenID connect provider, you can use it with AWS services
 * that expect an IAM OIDC provider. For example, when you define an <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/open-id.html">Amazon
 * Cognito identity
 * pool</a>
 * you can reference the provider's ARN as follows:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.cognito.*;
 * 
 * OpenIdConnectProvider myProvider;
 * 
 * CfnIdentityPool.Builder.create(this, "IdentityPool")
 *         .openIdConnectProviderArns(List.of(myProvider.getOpenIdConnectProviderArn()))
 *         // And the other properties for your identity pool
 *         .allowUnauthenticatedIdentities(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * The <code>OpenIdConnectPrincipal</code> class can be used as a principal used with a <code>OpenIdConnectProvider</code>, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * OpenIdConnectProvider provider = OpenIdConnectProvider.Builder.create(this, "MyProvider")
 *         .url("https://openid/connect")
 *         .clientIds(List.of("myclient1", "myclient2"))
 *         .build();
 * OpenIdConnectPrincipal principal = new OpenIdConnectPrincipal(provider);
 * </pre></blockquote>
 * <p>
 * <h2>SAML provider</h2>
 * <p>
 * An IAM SAML 2.0 identity provider is an entity in IAM that describes an external
 * identity provider (IdP) service that supports the SAML 2.0 (Security Assertion
 * Markup Language 2.0) standard. You use an IAM identity provider when you want
 * to establish trust between a SAML-compatible IdP such as Shibboleth or Active
 * Directory Federation Services and AWS, so that users in your organization can
 * access AWS resources. IAM SAML identity providers are used as principals in an
 * IAM trust policy.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * SamlProvider.Builder.create(this, "Provider")
 *         .metadataDocument(iam.SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The <code>SamlPrincipal</code> class can be used as a principal with a <code>SamlProvider</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * SamlProvider provider = SamlProvider.Builder.create(this, "Provider")
 *         .metadataDocument(iam.SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 *         .build();
 * SamlPrincipal principal = new SamlPrincipal(provider, Map.of(
 *         "StringEquals", Map.of(
 *                 "SAML:iss", "issuer")));
 * </pre></blockquote>
 * <p>
 * When creating a role for programmatic and AWS Management Console access, use the <code>SamlConsolePrincipal</code>
 * class:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * SamlProvider provider = SamlProvider.Builder.create(this, "Provider")
 *         .metadataDocument(iam.SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 *         .build();
 * Role.Builder.create(this, "Role")
 *         .assumedBy(new SamlConsolePrincipal(provider))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Users</h2>
 * <p>
 * IAM manages users for your AWS account. To create a new user:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * User user = new User(this, "MyUser");
 * </pre></blockquote>
 * <p>
 * To import an existing user by name <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">with path</a>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IUser user = iam.User.fromUserName(this, "MyImportedUserByName", "johnsmith");
 * </pre></blockquote>
 * <p>
 * To import an existing user by ARN:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IUser user = iam.User.fromUserArn(this, "MyImportedUserByArn", "arn:aws:iam::123456789012:user/johnsmith");
 * </pre></blockquote>
 * <p>
 * To import an existing user by attributes:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IUser user = iam.User.fromUserAttributes(this, "MyImportedUserByAttributes", UserAttributes.builder()
 *         .userArn("arn:aws:iam::123456789012:user/johnsmith")
 *         .build());
 * </pre></blockquote>
 * <p>
 * To add a user to a group (both for a new and imported user/group):
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * User user = new User(this, "MyUser"); // or User.fromUserName(stack, 'User', 'johnsmith');
 * Group group = new Group(this, "MyGroup"); // or Group.fromGroupArn(stack, 'Group', 'arn:aws:iam::account-id:group/group-name');
 * 
 * user.addToGroup(group);
 * // or
 * group.addUser(user);
 * </pre></blockquote>
 * <p>
 * <h2>Features</h2>
 * <p>
 * <ul>
 * <li>Policy name uniqueness is enforced. If two policies by the same name are attached to the same
 * principal, the attachment will fail.</li>
 * <li>Policy names are not required - the CDK logical ID will be used and ensured to be unique.</li>
 * <li>Policies are validated during synthesis to ensure that they have actions, and that policies
 * attached to IAM principals specify relevant resources, while policies attached to resources
 * specify which IAM principals they apply to.</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.iam;
