package software.amazon.awscdk.services.iam;

/**
 * Properties for defining a `AWS::IAM::VirtualMFADevice`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * CfnVirtualMFADeviceProps cfnVirtualMFADeviceProps = CfnVirtualMFADeviceProps.builder()
 *         .users(List.of("users"))
 *         // the properties below are optional
 *         .path("path")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualMfaDeviceName("virtualMfaDeviceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:41.934Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CfnVirtualMFADeviceProps")
@software.amazon.jsii.Jsii.Proxy(CfnVirtualMFADeviceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVirtualMFADeviceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::IAM::VirtualMFADevice.Path`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * `AWS::IAM::VirtualMFADevice.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::IAM::VirtualMFADevice.Users`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getUsers();

    /**
     * `AWS::IAM::VirtualMFADevice.VirtualMfaDeviceName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualMfaDeviceName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVirtualMFADeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVirtualMFADeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVirtualMFADeviceProps> {
        java.lang.String path;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.util.List<java.lang.String> users;
        java.lang.String virtualMfaDeviceName;

        /**
         * Sets the value of {@link CfnVirtualMFADeviceProps#getPath}
         * @param path `AWS::IAM::VirtualMFADevice.Path`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualMFADeviceProps#getTags}
         * @param tags `AWS::IAM::VirtualMFADevice.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualMFADeviceProps#getUsers}
         * @param users `AWS::IAM::VirtualMFADevice.Users`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(java.util.List<java.lang.String> users) {
            this.users = users;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualMFADeviceProps#getVirtualMfaDeviceName}
         * @param virtualMfaDeviceName `AWS::IAM::VirtualMFADevice.VirtualMfaDeviceName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualMfaDeviceName(java.lang.String virtualMfaDeviceName) {
            this.virtualMfaDeviceName = virtualMfaDeviceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVirtualMFADeviceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVirtualMFADeviceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVirtualMFADeviceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVirtualMFADeviceProps {
        private final java.lang.String path;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.util.List<java.lang.String> users;
        private final java.lang.String virtualMfaDeviceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.users = software.amazon.jsii.Kernel.get(this, "users", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.virtualMfaDeviceName = software.amazon.jsii.Kernel.get(this, "virtualMfaDeviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.path = builder.path;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.users = java.util.Objects.requireNonNull(builder.users, "users is required");
            this.virtualMfaDeviceName = builder.virtualMfaDeviceName;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getUsers() {
            return this.users;
        }

        @Override
        public final java.lang.String getVirtualMfaDeviceName() {
            return this.virtualMfaDeviceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            data.set("users", om.valueToTree(this.getUsers()));
            if (this.getVirtualMfaDeviceName() != null) {
                data.set("virtualMfaDeviceName", om.valueToTree(this.getVirtualMfaDeviceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.CfnVirtualMFADeviceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVirtualMFADeviceProps.Jsii$Proxy that = (CfnVirtualMFADeviceProps.Jsii$Proxy) o;

            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (!users.equals(that.users)) return false;
            return this.virtualMfaDeviceName != null ? this.virtualMfaDeviceName.equals(that.virtualMfaDeviceName) : that.virtualMfaDeviceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.users.hashCode());
            result = 31 * result + (this.virtualMfaDeviceName != null ? this.virtualMfaDeviceName.hashCode() : 0);
            return result;
        }
    }
}
