/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.$Module;
import software.amazon.awscdk.services.iam.IGroup;
import software.amazon.awscdk.services.iam.IPolicy;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.IUser;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyProps;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-iam.Policy")
public class Policy
extends Resource
implements IPolicy {
    protected Policy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Policy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Policy(@NotNull Construct scope, @NotNull String id, @Nullable PolicyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Policy(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addStatements(PolicyStatement ... statement) {
        Kernel.call((Object)this, (String)"addStatements", (NativeType)NativeType.VOID, (Object[])Arrays.stream(statement).toArray(Object[]::new));
    }

    public void attachToGroup(@NotNull IGroup group) {
        Kernel.call((Object)this, (String)"attachToGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(group, "group is required")});
    }

    public void attachToRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"attachToRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    public void attachToUser(@NotNull IUser user) {
        Kernel.call((Object)this, (String)"attachToUser", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(user, "user is required")});
    }

    @NotNull
    public static IPolicy fromPolicyName(@NotNull Construct scope, @NotNull String id, @NotNull String policyName) {
        return (IPolicy)JsiiObject.jsiiStaticCall(Policy.class, (String)"fromPolicyName", (NativeType)NativeType.forClass(IPolicy.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(policyName, "policyName is required")});
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @NotNull
    public PolicyDocument getDocument() {
        return (PolicyDocument)((Object)Kernel.get((Object)this, (String)"document", (NativeType)NativeType.forClass(PolicyDocument.class)));
    }

    @Override
    @NotNull
    public String getPolicyName() {
        return (String)Kernel.get((Object)this, (String)"policyName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Policy> {
        private final Construct scope;
        private final String id;
        private PolicyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder document(PolicyDocument document) {
            this.props().document(document);
            return this;
        }

        public Builder force(Boolean force) {
            this.props().force(force);
            return this;
        }

        public Builder groups(List<? extends IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        public Builder policyName(String policyName) {
            this.props().policyName(policyName);
            return this;
        }

        public Builder roles(List<? extends IRole> roles) {
            this.props().roles(roles);
            return this;
        }

        public Builder statements(List<? extends PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        public Builder users(List<? extends IUser> users) {
            this.props().users(users);
            return this;
        }

        public Policy build() {
            return new Policy(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private PolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new PolicyProps.Builder();
            }
            return this.props;
        }
    }
}

