package software.amazon.awscdk.services.iam;

/**
 * Represents a statement in an IAM policy document.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:16:46.853Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyStatement")
public class PolicyStatement extends software.amazon.jsii.JsiiObject {

    protected PolicyStatement(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyStatement(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyStatement(final software.amazon.awscdk.services.iam.PolicyStatementProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyStatement() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this));
    }

    /**
     * Add a condition that limits to a given account.
     * 
     * @param accountId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccountCondition(final java.lang.String accountId) {
        this.jsiiCall("addAccountCondition", Void.class, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccountRootPrincipal() {
        this.jsiiCall("addAccountRootPrincipal", Void.class);
    }

    /**
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addActions(final java.lang.String... actions) {
        this.jsiiCall("addActions", Void.class, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Adds a ``"*"`` resource to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAllResources() {
        this.jsiiCall("addAllResources", Void.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAnyPrincipal() {
        this.jsiiCall("addAnyPrincipal", Void.class);
    }

    /**
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addArnPrincipal(final java.lang.String arn) {
        this.jsiiCall("addArnPrincipal", Void.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * @param accountId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAwsAccountPrincipal(final java.lang.String accountId) {
        this.jsiiCall("addAwsAccountPrincipal", Void.class, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     * @param canonicalUserId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCanonicalUserPrincipal(final java.lang.String canonicalUserId) {
        this.jsiiCall("addCanonicalUserPrincipal", Void.class, new Object[] { java.util.Objects.requireNonNull(canonicalUserId, "canonicalUserId is required") });
    }

    /**
     * Add a condition to the Policy.
     * 
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCondition(final java.lang.String key, final java.lang.Object value) {
        this.jsiiCall("addCondition", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Add multiple conditions to the Policy.
     * 
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConditions(final java.util.Map<java.lang.String, java.lang.Object> conditions) {
        this.jsiiCall("addConditions", Void.class, new Object[] { java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * @param federated This parameter is required.
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFederatedPrincipal(final java.lang.Object federated, final java.util.Map<java.lang.String, java.lang.Object> conditions) {
        this.jsiiCall("addFederatedPrincipal", Void.class, new Object[] { federated, java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * @param notActions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotActions(final java.lang.String... notActions) {
        this.jsiiCall("addNotActions", Void.class, java.util.Arrays.<Object>stream(notActions).toArray(Object[]::new));
    }

    /**
     * @param notPrincipals This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotPrincipals(final software.amazon.awscdk.services.iam.IPrincipal... notPrincipals) {
        this.jsiiCall("addNotPrincipals", Void.class, java.util.Arrays.<Object>stream(notPrincipals).toArray(Object[]::new));
    }

    /**
     * @param arns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotResources(final java.lang.String... arns) {
        this.jsiiCall("addNotResources", Void.class, java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * @param principals This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPrincipals(final software.amazon.awscdk.services.iam.IPrincipal... principals) {
        this.jsiiCall("addPrincipals", Void.class, java.util.Arrays.<Object>stream(principals).toArray(Object[]::new));
    }

    /**
     * @param arns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addResources(final java.lang.String... arns) {
        this.jsiiCall("addResources", Void.class, java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * Adds a service principal to this policy statement.
     * 
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`). This parameter is required.
     * @param opts options for adding the service principal (such as specifying a principal in a different region).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addServicePrincipal(final java.lang.String service, final software.amazon.awscdk.services.iam.ServicePrincipalOpts opts) {
        this.jsiiCall("addServicePrincipal", Void.class, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), opts });
    }

    /**
     * Adds a service principal to this policy statement.
     * 
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addServicePrincipal(final java.lang.String service) {
        this.jsiiCall("addServicePrincipal", Void.class, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * JSON-ify the statement.
     * 
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object toJSON() {
        return this.jsiiCall("toJSON", java.lang.Object.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object toStatementJson() {
        return this.jsiiCall("toStatementJson", java.lang.Object.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * Indicates if this permission has a "Principal" section.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getHasPrincipal() {
        return this.jsiiGet("hasPrincipal", java.lang.Boolean.class);
    }

    /**
     * Indicates if this permission as at least one resource associated with it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getHasResource() {
        return this.jsiiGet("hasResource", java.lang.Boolean.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.Effect getEffect() {
        return this.jsiiGet("effect", software.amazon.awscdk.services.iam.Effect.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEffect(final software.amazon.awscdk.services.iam.Effect value) {
        this.jsiiSet("effect", java.util.Objects.requireNonNull(value, "effect is required"));
    }

    /**
     * Statement ID for this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getSid() {
        return this.jsiiGet("sid", java.lang.String.class);
    }

    /**
     * Statement ID for this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSid(final java.lang.String value) {
        this.jsiiSet("sid", value);
    }
}
