package software.amazon.awscdk.services.iam;

/**
 * Enables session tags on role assumptions from a principal.
 * <p>
 * For more information on session tags, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * IPrincipal principal;
 * SessionTagsPrincipal sessionTagsPrincipal = new SessionTagsPrincipal(principal);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:48:52.261Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.SessionTagsPrincipal")
public class SessionTagsPrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected SessionTagsPrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SessionTagsPrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param principal This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SessionTagsPrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal principal) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(principal, "principal is required") });
    }

    /**
     * Add the princpial to the AssumeRolePolicyDocument.
     * <p>
     * Add the statements to the AssumeRolePolicyDocument necessary to give this principal
     * permissions to assume the given role.
     * <p>
     * @param doc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addToAssumeRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument doc) {
        software.amazon.jsii.Kernel.call(this, "addToAssumeRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(doc, "doc is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPrincipalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }

    /**
     * The AWS account ID of this principal.
     * <p>
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalAccount() {
        return software.amazon.jsii.Kernel.get(this, "principalAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
