/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.List;
import software.amazon.awscdk.services.iam.IGroup;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.IUser;
import software.amazon.awscdk.services.iam.ManagedPolicyProps;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.JsiiSerializable;

public interface ManagedPolicyProps
extends JsiiSerializable {
    public String getDescription();

    public List<IGroup> getGroups();

    public String getManagedPolicyName();

    public String getPath();

    public List<IRole> getRoles();

    public List<PolicyStatement> getStatements();

    public List<IUser> getUsers();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private List<IGroup> groups;
        private String managedPolicyName;
        private String path;
        private List<IRole> roles;
        private List<PolicyStatement> statements;
        private List<IUser> users;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder groups(List<IGroup> groups) {
            this.groups = groups;
            return this;
        }

        public Builder managedPolicyName(String managedPolicyName) {
            this.managedPolicyName = managedPolicyName;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder roles(List<IRole> roles) {
            this.roles = roles;
            return this;
        }

        public Builder statements(List<PolicyStatement> statements) {
            this.statements = statements;
            return this;
        }

        public Builder users(List<IUser> users) {
            this.users = users;
            return this;
        }

        public ManagedPolicyProps build() {
            return new Jsii.Proxy(this.description, this.groups, this.managedPolicyName, this.path, this.roles, this.statements, this.users, null);
        }
    }
}

