/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.List;
import software.amazon.awscdk.core.SecretValue;
import software.amazon.awscdk.services.iam.IGroup;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.UserProps;
import software.amazon.jsii.JsiiSerializable;

public interface UserProps
extends JsiiSerializable {
    public List<IGroup> getGroups();

    public List<IManagedPolicy> getManagedPolicies();

    public SecretValue getPassword();

    public Boolean getPasswordResetRequired();

    public String getPath();

    public IManagedPolicy getPermissionsBoundary();

    public String getUserName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IGroup> groups;
        private List<IManagedPolicy> managedPolicies;
        private SecretValue password;
        private Boolean passwordResetRequired;
        private String path;
        private IManagedPolicy permissionsBoundary;
        private String userName;

        public Builder groups(List<IGroup> groups) {
            this.groups = groups;
            return this;
        }

        public Builder managedPolicies(List<IManagedPolicy> managedPolicies) {
            this.managedPolicies = managedPolicies;
            return this;
        }

        public Builder password(SecretValue password) {
            this.password = password;
            return this;
        }

        public Builder passwordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder permissionsBoundary(IManagedPolicy permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public UserProps build() {
            return new Jsii.Proxy(this.groups, this.managedPolicies, this.password, this.passwordResetRequired, this.path, this.permissionsBoundary, this.userName, null);
        }
    }
}

